% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ressource_route.R
\name{ressource_route}
\alias{ressource_route}
\title{Create a route for fetching files}
\usage{
ressource_route(
  ...,
  default_file = "index.html",
  default_ext = "html",
  finalize = NULL,
  continue = FALSE
)
}
\arguments{
\item{...}{Named arguments mapping a subpath in the URL to a location on the
file system. These mappings will be checked in sequence}

\item{default_file}{The default file to look for if the path does not map to
a file directly (see Details)}

\item{default_ext}{The default file extension to add to the file if a file
cannot be found at the provided path and the path does not have an extension
(see Details)}

\item{finalize}{An optional function to run if a file is found. The function
will recieve the request as the first argument, the response as the second,
and anything passed on through \code{...} in the \code{dispatch} method. Any return
value from the function is discarded.}

\item{continue}{A logical that should be returned if a file is found.
Defaults to \code{FALSE} indicating that the response should be send unmodified.}
}
\value{
Either \code{TRUE} if no file is found or \code{continue = TRUE} or \code{FALSE} if
a file is found and \code{continue = FALSE}
}
\description{
This function creates a route mapping different paths to files on the server
filesystem. Different subpaths can be mapped to different locations on the
server so that e.g. \verb{/data/} maps to \verb{/path/to/data/} and \verb{/assets/} maps to
\verb{/a/completely/different/path/}. The route support automatic expansion of
paths to a default extension or file, using compressed versions of files if
the request permits it, and setting the correct headers so that results are
cached.
}
\details{
The way paths are resolved to a file is, for every mounted location,
\enumerate{
\item Check if the path contains the mount point. If not, continue to the next
mount point
\item substitute the mount point for the local location in the path
\item if the path ends with \code{/} add the \code{default_file} (defaults to \code{index.html})
\item see if the file exists along with compressed versions (versions with
\code{.gz}, \code{.zip}, \code{.br}, \code{.zz} appended)
\item if any version exists, chose the prefered encoding based on the
\code{Accept-Encoding} header in the request, and return.
\item if none exists and the path does not specify a file extension, add
\code{default_ext} to the path and repeat 3-4
\item if none exists still and the path does not specify a file extension, add
\code{default_file} to the path and repeat 3-4
\item if none exists still, continue to the next mount point
}

This means that for the path \verb{/data/mtcars}, the following locations will be
tested (assuming the \verb{/data/} -> \verb{/path/to/data/} mapping):
\enumerate{
\item \verb{/path/to/data/mtcars}, \verb{/path/to/data/mtcars.gz},
\verb{/path/to/data/mtcars.zip}, \verb{/path/to/data/mtcars.br},
\verb{/path/to/data/mtcars.zz}
\item \verb{/path/to/data/mtcars.html}, \verb{/path/to/data/mtcars.html.gz},
\verb{/path/to/data/mtcars.html.zip}, \verb{/path/to/data/mtcars.html.br},
\verb{/path/to/data/mtcars.html.zz}
\item \verb{/path/to/data/mtcars/index.html}, \verb{/path/to/data/mtcars/index.html.gz},
\verb{/path/to/data/mtcars/index.html.zip}, \verb{/path/to/data/mtcars/index.html.br},
\verb{/path/to/data/mtcars/index.html.zz}
}

Assuming the default values of \code{default_file} and \code{default_ext}

If a file is not found, the route will simply return \code{TRUE} to hand of
control to subsequent routes in the stack, otherwise it will return the
logical value in the \code{continue} argument (defaults to \code{FALSE}, thus
shortcutting any additional routes in the stack).

If a file is found the request headers \code{If-Modified-Since} and
\code{If-None-Match}, will be fetched and, if exist, will be used to determine
whether a \verb{304 - Not Modified} response should be send instead of the file.
If the file should be send, it will be added to the response along with the
following headers:
\itemize{
\item \code{Content-Type} based on the extension of the file (without any encoding
extensions)
\item \code{Content-Encoding} based on the negotiated file encoding
\item \code{ETag} based on \code{\link[digest:digest]{digest::digest()}} of the last modified date
\item \code{Cache-Control} set to \code{max-age=3600}
}

Furthermore \code{Content-Length} will be set automatically by \code{httpuv}

Lastly, if found, the finalize function will be called, forwarding the
\code{request}, \code{response} and \code{...} from the \code{dispatch} method.
}
\examples{
# Map package files
res_route <- ressource_route(
  '/package_files/' = system.file(package = 'routr')
)

rook <- fiery::fake_request('http://example.com/package_files/DESCRIPTION')
req <- reqres::Request$new(rook)
res_route$dispatch(req)
req$response$as_list()
}
\seealso{
Other Route constructors: 
\code{\link{sizelimit_route}()}
}
\concept{Route constructors}
