% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-sim_resp.R
\name{sim_resp}
\alias{sim_resp}
\alias{sim_resp_eq}
\title{Response component}
\usage{
sim_resp(simSetup, respFun)

sim_resp_eq(simSetup, ...)
}
\arguments{
\item{simSetup}{a \code{sim_setup}.}

\item{respFun}{a function constructing the response variable}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Name-value pairs.
The name gives the name of the column in the output.

The value can be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item A vector the same length as the current group (or the whole data frame
if ungrouped).
\item \code{NULL}, to remove the column.
\item A data frame or tibble, to create multiple columns in the output.
}}
}
\description{
One of the components which can be added to a \code{sim_setup}.
}
\details{
Potentially you can define an \code{respFun} yourself. Take care that it only has one argument, named \code{dat}, and returns the a \code{data.frame}.
}
\examples{
base_id() \%>\% sim_gen_x() \%>\% sim_gen_e() \%>\% sim_resp_eq(y = 100 + 2 * x + e)
}
\seealso{
\code{\link{agg_all}}, \code{\link{sim_gen}}, \code{\link{sim_comp_pop}}, \code{\link{sim_sample}}, , \code{\link{sim_comp_sample}}
}
