% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orders.R
\name{schwab_orderSearch}
\alias{schwab_orderSearch}
\title{Search for orders by date}
\usage{
schwab_orderSearch(
  account_number,
  startDate = Sys.Date() - 30,
  endDate = Sys.Date(),
  maxResults = 50,
  orderStatus = "",
  accessTokenList = NULL
)
}
\arguments{
\item{account_number}{A Schwab account number associated with the Access Token}

\item{startDate}{Orders from a certain date with. Format yyyy-mm-dd.}

\item{endDate}{Filter orders that occurred before a certain date. Format
yyyy-mm-dd}

\item{maxResults}{the max results to return in the query}

\item{orderStatus}{search by order status (ACCEPTED, FILLED, EXPIRED,
CANCELED, REJECTED, etc). This can be left blank for all orders. See
documentation for full list}

\item{accessTokenList}{A valid Access Token must be set using the output from
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
a list of three objects: a jsonlite formatted extract of all orders,
  all entered orders with details, a data frame of all executed orders with
  the executions
}
\description{
Search for orders associated with a Schwab account over the previous 60 days. The
result is a list of three objects:
\enumerate{
\item jsonlite formatted extract of all orders
\item all entered orders with details
\item a data frame of all executed orders with the executions }
}
\examples{
\dontrun{

# Get all orders run over the last 50 days (up to 500)
schwab_orderSearch(account_number = account_number,
            startDate = Sys.Date()-50,
            maxResults = 500, orderStatus = '')

}
}
