% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_nhmm.R
\name{simulate_nhmm}
\alias{simulate_nhmm}
\title{Simulate Non-homogeneous Hidden Markov Models}
\usage{
simulate_nhmm(
  n_states,
  emission_formula,
  initial_formula = ~1,
  transition_formula = ~1,
  data,
  id,
  time,
  coefs = NULL,
  init_sd = 2 * is.null(coefs)
)
}
\arguments{
\item{n_states}{An integer > 1 defining the number of hidden states.}

\item{emission_formula}{of class \code{\link[=formula]{formula()}} for the
state emission probabilities, or a list of such formulas in case of multiple
response variables. The left-hand side of formulas define the responses.
For multiple responses having same formula, you can use a form
\code{c(y1, y2) ~ x}, where \code{y1} and \code{y2} are the response variables.}

\item{initial_formula}{of class \code{\link[=formula]{formula()}} for the
initial state probabilities. Left-hand side of the formula should be empty.}

\item{transition_formula}{of class \code{\link[=formula]{formula()}} for the state transition
probabilities. Left-hand side of the formula should be empty.}

\item{data}{A data frame containing the variables used in the model
formulas. Note that this should also include also the response variable(s),
which are used to define the number of observed symbols (using \code{\link[=levels]{levels()}})
and the length of sequences. The actual values of the response variables
does not matter though, as they are replaced by the simulated values. The
exception is the first time point in FAN-HMM case: If the \code{emission_formula}
contains lagged responses, the response variable values at the first time
point are used to define the emissions at the second time point, and the
simulations are done from the second time point onwards. This matches the
case \code{prior_obs = "fixed"} in \code{\link[=estimate_nhmm]{estimate_nhmm()}}.}

\item{id}{Name of the id variable in \code{data} identifying different
sequences.}

\item{time}{Name of the time index variable in \code{data}.}

\item{coefs}{Same as argument \code{inits} in \code{\link[=estimate_nhmm]{estimate_nhmm()}}. If \code{NULL},
(default), the model parameters are generated randomly. If you want to
simulate new sequences based on an estimated model \code{fit}, you can use
\code{coefs = fit$etas} and \code{init_sd = 0}.}

\item{init_sd}{Standard deviation of the normal distribution used to
generate random coefficients. Default is \code{2} when \code{coefs} is \code{NULL} and \code{0}
otherwise.}
}
\value{
A list with the model used in simulation as well as the simulated
hidden state sequences.
}
\description{
Simulate sequences of observed and hidden states given the parameters of a
non-homogeneous hidden Markov model.
}
