% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.R
\name{chat_ui}
\alias{chat_ui}
\title{Create a chat UI element}
\usage{
chat_ui(
  id,
  ...,
  messages = NULL,
  placeholder = "Enter a message...",
  width = "min(680px, 100\%)",
  height = "auto",
  fill = TRUE
)
}
\arguments{
\item{id}{The ID of the chat element}

\item{...}{Extra HTML attributes to include on the chat element}

\item{messages}{A list of messages to prepopulate the chat with. Each
message can be one of the following:
\itemize{
\item A string, which is interpreted as markdown and rendered to HTML on
the client.
\itemize{
\item To prevent interpreting as markdown, mark the string as
\code{\link[htmltools:HTML]{htmltools::HTML()}}.
}
\item A UI element.
\itemize{
\item This includes \code{\link[htmltools:tagList]{htmltools::tagList()}}, which take UI elements
(including strings) as children. In this case, strings are still
interpreted as markdown as long as they're not inside HTML.
}
\item A named list of \code{content} and \code{role}. The \code{content} can contain content
as described above, and the \code{role} can be "assistant" or "user".
}}

\item{placeholder}{The placeholder text for the chat's user input field}

\item{width}{The CSS width of the chat element}

\item{height}{The CSS height of the chat element}

\item{fill}{Whether the chat element should try to vertically fill its
container, if the container is
\href{https://rstudio.github.io/bslib/articles/filling/index.html}{fillable}}
}
\value{
A Shiny tag object, suitable for inclusion in a Shiny UI
}
\description{
Inserts a chat UI element into a Shiny UI, which includes a scrollable
section for displaying chat messages, and an input field for the user to
enter new messages.

To respond to user input, listen for \code{input$ID_user_input} (for example, if
\code{id="my_chat"}, user input will be at \code{input$my_chat_user_input}), and use
\code{\link[=chat_append]{chat_append()}} to append messages to the chat.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(bslib)
library(shinychat)

ui <- page_fillable(
  chat_ui("chat", fill = TRUE)
)

server <- function(input, output, session) {
  observeEvent(input$chat_user_input, {
    # In a real app, this would call out to a chat model or API,
    # perhaps using the 'ellmer' package.
    response <- paste0(
      "You said:\n\n",
      "<blockquote>",
      htmltools::htmlEscape(input$chat_user_input),
      "</blockquote>"
    )
    chat_append("chat", response)
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
