% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{addhealth}
\alias{addhealth}
\title{Adolescent Depression Data from the Add Health Study}
\format{
A data frame with 2061 rows and 18 variables:
\describe{
\item{\code{GRADE}}{Respondent's grade level at Wave I.}
\item{\code{SEX}}{Respondent's sex \cr levels: (1)\code{Male}, (2)\code{Female}.}
\item{\code{S1w1}, \code{S1w2}}{I felt that I could not shake off the blues even with help from my family and friends.}
\item{\code{S2w1}, \code{S2w2}}{I felt depressed.}
\item{\code{S3w1}, \code{S3w2}}{I felt lonely.}
\item{\code{S4w1}, \code{S4w2}}{I felt sad.}
\item{\code{D1w1}, \code{D1w2}}{People were unfriendly to me.}
\item{\code{D2w1}, \code{D2w2}}{I felt that people disliked me}
\item{\code{F1w1}, \code{F1w2}}{I thought my life had been a failure.}
\item{\code{F2w1}, \code{F2w2}}{I felt life was not worth living}
}
}
\source{
\url{https://addhealth.cpc.unc.edu/data/#public-use}
}
\usage{
addhealth
}
\description{
This dataset contains responses from the National Longitudinal Study of Adolescent Health (Add Health), focusing on adolescents' experiences with depression. The subjects, who were in Grades 10 and 11 during the 1994–1995 academic year, provided data on at least one measure of adolescent delinquency in Wave I. \cr
These data can be used to replicate the latent class analysis conducted by Collins and Lanza (2009).\cr
The dataset includes five covariates, notably grade level and sex of respondents, along with variables capturing depressive emotions: sadness (\code{S1-S4}), feeling disliked (\code{D1-D2}), and feelings of failure (\code{F1-F2}). \cr
Responses for these variables were initially categorized as "Never," "Sometimes," "Often," or "Most or All of the Time." In this dataset, responses have been recoded as "No" for "Never" and "Yes" for all other responses, providing  a longitudinal perspective on adolescent depression across Waves I and II. Variables with the suffix \code{"w1"} are from Wave I, while those with the suffix \code{"w2"} are from Wave II.
}
\examples{
library(magrittr)
data <- addhealth[1:100,]
lta5 <- slca(
   DEP1(5) ~ S1w1 + S2w1 + S3w1 + S4w1 + D1w1 + D2w1 + F1w1 + F2w1,
   DEP2(5) ~ S1w2 + S2w2 + S3w2 + S4w2 + D1w2 + D2w2 + F1w2 + F2w2,
   DEP1 ~ DEP2
) \%>\% estimate(data, control = list(em.tol = 1e-6))
lta5inv <- slca(
   DEP1(5) ~ S1w1 + S2w1 + S3w1 + S4w1 + D1w1 + D2w1 + F1w1 + F2w1,
   DEP2(5) ~ S1w2 + S2w2 + S3w2 + S4w2 + D1w2 + D2w2 + F1w2 + F2w2,
   DEP1 ~ DEP2,
   constraints = c("DEP1", "DEP2")
) \%>\% estimate(data, control = list(em.tol = 1e-6))

compare(lta5inv, lta5, test = "chisq")
lta5inv \%>\% param()
}
\references{
Collins, L.M., & Lanza, S.T. (2009). Latent Class and Latent Transition Analysis: With Applications in the Social, Behavioral, and Health Sciences.

J.R. Udry. The National Longitudinal Study of Adolescent Health (Add Health), Waves I & II, 1994-1996. Carolina Population Center, University of North Carolina at Chapel Hill, Chapel Hill, NC, 2003.
}
\keyword{datasets}
