% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selfunctions.R
\name{getSELWeights}
\alias{getSELWeights}
\title{Construct memory-efficient weights for estimation}
\usage{
getSELWeights(x, bw = NULL, ..., trim = NULL, renormalise = TRUE)
}
\arguments{
\item{x}{A numeric vector (with many close-to-zero elements).}

\item{bw}{A numeric scalar or a vector passed to `kernelWeights`.}

\item{...}{Other arguments pased to \code{kernelWeights}.}

\item{trim}{A trimming function that returns a threshold value below which the weights are ignored. In common applications, this function should tend to 0 as the length of \code{x} increases.}

\item{renormalise}{Logical; passed to `sparseVectorToList`.}
}
\value{
A list with indices of large enough elements.
}
\description{
This function constructs SEL weights with appropriate trimming for numerical stability and optional renormalisation so that the sum of the weights be unity
}
\examples{
getSELWeights(1:5, bw = 2, kernel = "triangular")
}
