structure(list(method = "GET", url = "https://api.us.socrata.com/api/catalog/v1?limit=10&only=dataset&q=bus", 
    status_code = 200L, headers = structure(list(Server = "nginx", 
        Date = "Tue, 22 Jul 2025 20:42:00 GMT", `Content-Type` = "application/json;charset=utf-8", 
        `Transfer-Encoding` = "chunked", Connection = "keep-alive", 
        `Access-Control-Allow-Origin` = "*", Vary = "Accept-Encoding", 
        `Content-Encoding` = "gzip", `X-Socrata-Region` = "aws-us-east-1-fedramp-prod", 
        `Strict-Transport-Security` = "max-age=31536000; includeSubDomains"), class = "httr2_headers"), 
    body = charToRaw("{\n  \"results\" :\n    [\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Bus Breakdown and Delays\",\n            \"id\" : \"ez4e-fazm\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"The Bus Breakdown and Delay system collects information from school bus vendors operating out in the field in real time. Bus staff that encounter delays during the route are instructed to radio the dispatcher at the bus vendor’s central office. The bus vendor staff are then instructed to log into the Bus Breakdown and Delay system to record the event and notify OPT. OPT customer service agents use this system to inform parents who call with questions regarding bus service. The Bus Breakdown and Delay system is publicly accessible and contains real time updates. All information in the system is entered by school bus vendor staff.\",\n            \"attribution\" : \"Department of Education (DOE)\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T10:34:16.000Z\",\n            \"createdAt\" : \"2015-09-30T17:08:23.000Z\",\n            \"metadata_updated_at\" : \"2024-11-26T23:16:32.000Z\",\n            \"data_updated_at\" : \"2025-07-22T10:34:16.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 163,\n                \"page_views_last_month\" : 808,\n                \"page_views_total\" : 37611,\n                \"page_views_last_week_log\" : 7.357552004618085,\n                \"page_views_last_month_log\" : 9.659995892429977,\n                \"page_views_total_log\" : 15.198905402581905\n              },\n            \"columns_name\" :\n              [\n                \"Boro\",\n                \"Has_Contractor_Notified_Schools\",\n                \"Busbreakdown_ID\",\n                \"Number_Of_Students_On_The_Bus\",\n                \"Have_You_Alerted_OPT\",\n                \"School_Year\",\n                \"School_Age_or_PreK\",\n                \"Reason\",\n                \"Bus_Company_Name\",\n                \"Last_Updated_On\",\n                \"Created_On\",\n                \"Breakdown_or_Running_Late\",\n                \"Occurred_On\",\n                \"How_Long_Delayed\",\n                \"Route_Number\",\n                \"Run_Type\",\n                \"Has_Contractor_Notified_Parents\",\n                \"Bus_No\",\n                \"Schools_Serviced\",\n                \"Informed_On\",\n                \"Incident_Number\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"boro\",\n                \"has_contractor_notified_schools\",\n                \"busbreakdown_id\",\n                \"number_of_students_on_the_bus\",\n                \"have_you_alerted_opt\",\n                \"school_year\",\n                \"school_age_or_prek\",\n                \"reason\",\n                \"bus_company_name\",\n                \"last_updated_on\",\n                \"created_on\",\n                \"breakdown_or_running_late\",\n                \"occurred_on\",\n                \"how_long_delayed\",\n                \"route_number\",\n                \"run_type\",\n                \"has_contractor_notified_parents\",\n                \"bus_no\",\n                \"schools_serviced\",\n                \"informed_on\",\n                \"incident_number\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Calendar date\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Borough, county or state in which the delay occurred, as entered by the staff employed by the reporting bus vendor.\",\n                \"Indicator status as reported by the staff employed by the reporting bus vendor. OPT does not systematically monitor the contents of this field in real time.\",\n                \"Unique ID of each record.\",\n                \"Number of students on the bus at the time of the incident as estimated by the staff employed by the reporting bus vendor. OPT does not systematically monitor the contents of this field in real time.\",\n                \"Indicator status as reported by the staff employed by the reporting bus vendor. OPT does not systematically monitor the contents of this field in real time.\",\n                \"Indicates the school year the record refers to. The DOE school year starts in September every year. \",\n                \"Indicator of whether the route serves the school-age or Pre-K/EI population. These two busing types have very different contract terms. OPT does not perform route planning for Pre-K service and doesn't assign route numbers.\",\n                \"Reason for delay as entered by staff employed by reporting bus vendor. User chooses from the following categories:\\n•\\tAccident - to be selected if any accident that delays the bus is recorded. The bus can be delayed by an accident that the bus itself is not actually involved in. \\n•\\tDelayed by School - to be selected by reporting bus vendors when schools have delays ushering students to or from the bus.\\n•\\tFlat Tire - to be selected by reporting bus vendors for any flat tire that requires the bus to stop and wait for assistance\\n•\\tHeavy Traffic - to be selected by the reporting bus vendor when heavy traffic conditions delay the scheduled service.\\n•\\tMechanical Problem -  to be selected by reporting bus vendors for any type of mechanical problem other than 'Flat Tire' or 'Won't Start'\\n•\\tOther - to be selected by the reporting bus vendor when the delay cannot be classified within the available categories\\n•\\tProblem Run - Some routes may be late to a destination because the bus vendor believes the route has too many stops or is too long. There is a process for bus vendors to submit these Problem Runs to OPT staff for research and resolution. While that work is being done, bus vendors can record routes as being delayed by selecting the Problem Run category.\\n•\\tWeather Conditions - to be selected by the reporting bus vendor when weather conditions delay the scheduled service.\\n•\\tWon't Start - to be selected by the reporting bus vendor when a bus that has already left the bus yard won't start. There is usually a delay while a replacement bus is dispatched to the out-of-service bus's location\\n\",\n                \"Bus vendor name of the reporting bus vendor.\",\n                \"Time/date the record was last edited in the OPT Breakdown and Delay system.\",\n                \"Time/date the record was created in the OPT Breakdown and Delay system.\",\n                \"Indicator status as reported by the staff employed by the reporting bus vendor. OPT does not edit this field. Designates whether a bus has broken down (and requires another vehicle to be dispatched to finish the route) or is delayed (and may not require another vehicle).\",\n                \"Time/date the incident occurred, as entered by the staff employed by the reporting bus vendor\",\n                \"Length of delay as estimated by the staff employed by the reporting bus vendor. OPT does not systematically monitor the contents of this field in real time.\",\n                \"This refers to the unique identifier four (1 alpha + 3 numeric) character route numbers indicate curb-to-curb service while five (1 alpha + 4 numeric) indicates stop-to-school service. Pre-K/EI routes may have any value in the Route Number field; bus vendors are not required to follow any naming convention for those routes.\",\n                \"Designates whether a breakdown or delay occurred on a specific category of busing service. The categories are:\\n•\\tGeneral Ed AM Run - stop-to-school service in the morning with pick-ups at bus stops and drops-offs at school(s). \\n•\\tGeneral Ed PM Run - stop-to-school service in the afternoon with pick-ups at school(s) and drop-offs at bus stops.\\n•\\tGeneral Ed Field Trip - refers to any mid-day bus trip that does not involve at least one student with an IEP for busing. For OPT, the term \\\"field trip\\\" is a contract term referring to any mid-day trip, including work programs as well as traditional field trips to the museum.\\n•\\tSpecial Ed AM Run – curb-to-curb service in the morning with pick-ups at residences and drop-offs at school(s).\\n•\\tSpecial Ed PM Run - curb-to-curb service in the afternoon with pick-ups at school(s) and drop-offs at residences.\\n•\\tSpecial Ed Field Trip - refers to any mid-day bus trip that includes at least one student with an IEP for busing. For OPT, the term \\\"field trip\\\" is a contract term referring to any mid-day trip, including work programs as well as traditional field trips to the museum.\\n•\\tPre-K/EI - Pre-Kindergarten or Early Intervention program curb-to-curb run. Pre-K/EI service has different service levels and contract terms from OPT's school aged service. OPT provides curb-to-curb busing to Pre-K students with an Individualized Education Program (IEP) for busing and selected children in the Dept. of Health and Mental Hygiene’s Early Intervention program.\\n•\\tProject Read PM Run – curb-to-curb busing service for special education students enrolled in late-day programs. As a rule, bus service is only available to schools or sites that dismiss students before 4:30 PM. There are a small number of approved programs that dismiss students after 4:30 PM.\\n\",\n                \"Indicator status as reported by the staff employed by the reporting bus vendor. OPT does not systematically monitor the contents of this field in real time.\",\n                \"The bus number is assigned by the bus vendor. The numbers are not unique identifiers and may be repeated across vendors. For example, many bus vendors may have a Bus #1. Each bus vendor may have their own numbering convention.\",\n                \"OPT Codes of all transportation sites on the route. If there is more than one site, each site code will be separated by a comma. If the incident occurred on a bus used for Pre-K/EI service, the code will have one alpha, three numeric and sometimes one additional alpha character. If the incident occurred on a bus used for school-aged service, the code will have five text formatted numerals and may include a leading zero.\",\n                \"Date on which the school, parents or OPT was notified, as reported by the bus vendor.\",\n                \"Some reports of bus breakdowns or delays originate from calls to the OPT Customer Service line who records incidents. When this happens, the record will have the Incident reference number.\"\n              ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"view\" : \"date_time\", \"align\" : \"left\" },\n                { \"view\" : \"date_time\", \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"view\" : \"date_time\", \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"view\" : \"date_time\", \"align\" : \"left\" },\n                { \"align\" : \"left\" }\n              ],\n            \"download_count\" : 14976,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2016-05-03T22:59:56.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"bus\", \"doe\", \"schools\", \"transportation\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Update_Automation\", \"value\" : \"Yes\" },\n                { \"key\" : \"Update_Date-Made-Public\", \"value\" : \"4/11/2016\" },\n                { \"key\" : \"Update_Update-Frequency\", \"value\" : \"Daily\" },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Department of Education (DOE)\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofnewyork.us\" },\n        \"permalink\" : \"https://data.cityofnewyork.us/d/ez4e-fazm\",\n        \"link\" : \"https://data.cityofnewyork.us/Transportation/Bus-Breakdown-and-Delays/ez4e-fazm\",\n        \"owner\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"DART Bus Schedules\",\n            \"id\" : \"6qat-uaei\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This contains all the routes, stop location, stop times, and trip information for all DART bus routes.\",\n            \"attribution\" : \"Department of Transportation, Delaware Transit Corportation\",\n            \"attribution_link\" : \"http://www.dartfirststate.com/information/routes/index.shtml\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2022-10-06T20:17:33.000Z\",\n            \"createdAt\" : \"2017-07-28T12:22:01.000Z\",\n            \"metadata_updated_at\" : \"2022-10-06T20:17:33.000Z\",\n            \"data_updated_at\" : \"2019-10-30T19:58:29.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 18,\n                \"page_views_last_month\" : 81,\n                \"page_views_total\" : 6567,\n                \"page_views_last_week_log\" : 4.247927513443585,\n                \"page_views_last_month_log\" : 6.357552004618085,\n                \"page_views_total_log\" : 12.681238411777805\n              },\n            \"columns_name\" :\n              [\n                \"ROUTE_NAME\",\n                \"Geocoded Location (state)\",\n                \"DIRECTION_NAME\",\n                \"Geocoded Location (zip)\",\n                \"Geocoded Location (city)\",\n                \"Geocoded Location (address)\",\n                \"Geocoded Location\",\n                \"PATTERNID\",\n                \"ROUTE\",\n                \"BLOCK_NUM\",\n                \"STOP_ABBR\",\n                \"SERVICE_ID\",\n                \"POCKETSCHEDULE_NAME\",\n                \"SERVICE_NAME\",\n                \"STOP_SEQUENCE\",\n                \"STOP_LON\",\n                \"STOP_LAT\",\n                \"WEEK_TEMPLATE\",\n                \"DESTINATIONSIGN_NAME\",\n                \"TRIP_TOTIME\",\n                \"STOPID\",\n                \"STOP_NAME\",\n                \"TRIP_FROMTIME\",\n                \"TRIPID\",\n                \"STOP_TIME\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"route_name\",\n                \"geocoded_location_state\",\n                \"direction_name\",\n                \"geocoded_location_zip\",\n                \"geocoded_location_city\",\n                \"geocoded_location_address\",\n                \"geocoded_location\",\n                \"patternid\",\n                \"route\",\n                \"block_num\",\n                \"stop_abbr\",\n                \"service_id\",\n                \"pocketschedule_name\",\n                \"service_name\",\n                \"stop_sequence\",\n                \"stop_lon\",\n                \"stop_lat\",\n                \"week_template\",\n                \"destinationsign_name\",\n                \"trip_totime\",\n                \"stopid\",\n                \"stop_name\",\n                \"trip_fromtime\",\n                \"tripid\",\n                \"stop_time\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Point\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Contains the full name of a route. This name will often include the route's destination sign name or last stop name. \",\n                \"\",\n                \"Contains text which indicates the direction of travel for a Trip. Used for separating trips by direction when publishing time tables and distinguishing between bi-directional trips with the same Route. \\nValues = Outbound, Inbound\\nOutbound: Travel in one direction\\nInbound: Travel in opposite direction. \",\n                \"\",\n                \"\",\n                \"\",\n                \"This field is used to combine latitude and longitude into one field to be able to display on a map.\",\n                \"Contains an ID that uniquely identifies a Pattern. Multiple blocks are a combination of a specific Pattern. \",\n                \"Contains an ID that uniquely identifies a route. \",\n                \"Contains an ID that uniquely identifies a Block. \\nIt used in identifying which trip belongs to a block. A block consists of two or more sequential trips made using the same vehicle, where a passenger can transfer from one trip to the next just by staying in the vehicle. The block_num is referenced by two or more TripID’s. \",\n                \"Contains short text or alpha numeric value that used in identifying the stop, referenced by the StopID column. \",\n                \"Contains an ID that uniquely identifies a service. It is referenced by the Service_Name and Week_Template columns. \",\n                \"Contains the alias name of a stop used on DART pocket schedule time table. \",\n                \"Contains the full name of the service. This text often indicates what type of service is being used. Example: Weekday, Saturday, Sunday, Resort Weekday. \",\n                \"Identifies the order of the stops for a particular trip. The values for Stop_Sequence will be increasing along the trip. There might be missing Stop_Sequence values in the order, which is common. \",\n                \"Contains the longitude of a stop.\",\n                \"Contains the latitude of a stop. \",\n                \"Contains a binary value that indicates whether the service is valid for the day(s) of the week starting from Sunday to Saturday.\\n“Sunday Monday Tuesday Wednesday Thursday Friday Saturday.”\\nExample: 0111110. A value of ‘0’ indicates that service is not available for that day, whereas 1 represents service is available for that day. \\nNote: Transit day Start time and End time of all days is from 3:00 am to next day 2:59 am.  \",\n                \"Contains the text that appears on the bus sign that identifies the trip's destination to passengers. This field is also used to distinguish between different patterns (PatternID) of service in the same route. Usually, major landmark names are used in this data.\",\n                \"Contains specific Trip end time. The last stop time(Stop_Time) value of a specific Trip(TripID) is entered here.\",\n                \"Contains an ID that uniquely identifies a stop. Multiple routes may use the same stop. The StopID is unique.\",\n                \"Contains the name of a stop. \",\n                \"Contains specific Trip start time. The first stop time(Stop_Time) value of a specific Trip(TripID) is entered here.\",\n                \"Contains an ID that identifies a trip.\",\n                \"Specifies the stop arrival time at a specific stop for a specific trip on a route. \"\n              ],\n            \"columns_format\" :\n              [\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                {},\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                {},\n                {},\n                {},\n                { \"view\" : \"address_coords\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"right\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"right\" }\n              ],\n            \"download_count\" : 635,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-08-03T17:10:34.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [ \"bus\", \"dart\", \"route\", \"schedule\", \"transit\", \"trip\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Additional-Information_Geographic-Unit\",\n                  \"value\" : \"Latitude/Longitude\"\n                },\n                {\n                  \"key\" : \"Additional-Information_Temporal-Coverage\",\n                  \"value\" : \"Current bus schedules\"\n                },\n                {\n                  \"key\" : \"Additional-Information_Frequency-of-publishing\",\n                  \"value\" : \"Semi-annually\"\n                }\n              ]\n          },\n        \"metadata\" :\n          { \"domain\" : \"data.delaware.gov\", \"license\" : \"Public Domain\" },\n        \"permalink\" : \"https://data.delaware.gov/d/6qat-uaei\",\n        \"link\" : \"https://data.delaware.gov/Transportation/DART-Bus-Schedules/6qat-uaei\",\n        \"owner\" :\n          {\n            \"id\" : \"hcy5-vbv6\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Delaware Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"hcy5-vbv6\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Delaware Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"KCATA Bus Stops\",\n            \"id\" : \"bd2s-bfst\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This data set includes the location of bus stops.\",\n            \"attribution\" : \"KCATA Transit Data\",\n            \"attribution_link\" : \"http://www.kcata.org/transit_data/access_gtdf\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2023-12-29T17:57:53.000Z\",\n            \"createdAt\" : \"2013-04-23T15:40:05.000Z\",\n            \"metadata_updated_at\" : \"2023-12-29T17:57:53.000Z\",\n            \"data_updated_at\" : \"2023-03-02T21:35:47.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 22,\n                \"page_views_last_month\" : 104,\n                \"page_views_total\" : 8170,\n                \"page_views_last_week_log\" : 4.523561956057013,\n                \"page_views_last_month_log\" : 6.714245517666122,\n                \"page_views_total_log\" : 12.996296936687374\n              },\n            \"columns_name\" :\n              [\n                \"Neighborhood Census\",\n                \"Council Districts\",\n                \"County Boundary\",\n                \"Zip Codes\",\n                \"Location 1 (address)\",\n                \"Location\",\n                \"Stop ID\",\n                \"Location 1 (city)\",\n                \"Location 1 (zip)\",\n                \"Stop Name\",\n                \"Location 1 (state)\"\n              ],\n            \"columns_field_name\" :\n              [\n                \":@computed_region_kk66_ngf4\",\n                \":@computed_region_9t2m_phkm\",\n                \":@computed_region_my34_vmp8\",\n                \":@computed_region_w4hf_t6bp\",\n                \"location_address\",\n                \"location\",\n                \"stop_id\",\n                \"location_city\",\n                \"location_zip\",\n                \"stop_name\",\n                \"location_state\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Point\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [ \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" : [ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {} ],\n            \"download_count\" : 11871,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2023-03-02T21:31:44.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"bdkc\", \"bus\", \"bus stops\", \"transit\" ],\n            \"domain_metadata\" : []\n          },\n        \"metadata\" : {\n                       \"domain\" : \"data.kcmo.org\",\n                       \"license\" : \"Public Domain\"\n                     },\n        \"permalink\" : \"https://data.kcmo.org/d/bd2s-bfst\",\n        \"link\" : \"https://data.kcmo.org/Transportation/KCATA-Bus-Stops/bd2s-bfst\",\n        \"owner\" :\n          {\n            \"id\" : \"p5d5-8ryp\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"DataKC\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"p5d5-8ryp\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"DataKC\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Bronx Bus Stops\",\n            \"id\" : \"eqmj-6b8d\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Bronx Transit Bus Stops\",\n            \"attribution\" : \"mta.info\",\n            \"attribution_link\" : \"http://mta.info/developers/download.html\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2019-02-15T18:15:27.000Z\",\n            \"createdAt\" : \"2012-10-06T01:37:39.000Z\",\n            \"metadata_updated_at\" : \"2019-02-15T18:15:27.000Z\",\n            \"data_updated_at\" : \"2012-10-06T01:43:42.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 4,\n                \"page_views_last_month\" : 12,\n                \"page_views_total\" : 8171,\n                \"page_views_last_week_log\" : 2.321928094887362,\n                \"page_views_last_month_log\" : 3.700439718141092,\n                \"page_views_total_log\" : 12.996473488733228\n              },\n            \"columns_name\" : [\n                               \"Location\",\n                               \"Stop ID\",\n                               \"Zip Codes\",\n                               \"Stop Name\"\n                             ],\n            \"columns_field_name\" :\n              [\n                \"location\",\n                \"stop_id\",\n                \":@computed_region_tx27_6f7w\",\n                \"stop_name\"\n              ],\n            \"columns_datatype\" : [ \"Point\", \"Number\", \"Number\", \"Text\" ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {}\n              ],\n            \"download_count\" : 551,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2012-10-06T01:44:12.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Environment\",\n            \"domain_tags\" : [ \"mta\", \"transit bus stops\" ],\n            \"domain_metadata\" : []\n          },\n        \"metadata\" :\n          { \"domain\" : \"bronx.lehman.cuny.edu\", \"license\" : \"Public Domain\" },\n        \"permalink\" : \"https://bronx.lehman.cuny.edu/d/eqmj-6b8d\",\n        \"link\" : \"https://bronx.lehman.cuny.edu/Environment/Bronx-Bus-Stops/eqmj-6b8d\",\n        \"owner\" :\n          {\n            \"id\" : \"3fqa-4a6j\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Elkin\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"3fqa-4a6j\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Elkin\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Capital District Bus Stops\",\n            \"id\" : \"wgnh-hpq9\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Bus stops from the Capital District Transportation Authority\",\n            \"attribution\" : \"Capital District Transportation Authority\",\n            \"attribution_link\" : null,\n            \"contact_email\" : \"opendata@its.ny.gov\",\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2024-10-28T12:55:54.000Z\",\n            \"createdAt\" : \"2013-05-22T20:13:49.000Z\",\n            \"metadata_updated_at\" : \"2024-10-28T12:55:53.000Z\",\n            \"data_updated_at\" : \"2024-10-28T12:55:54.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 24,\n                \"page_views_last_month\" : 94,\n                \"page_views_total\" : 4834,\n                \"page_views_last_week_log\" : 4.643856189774724,\n                \"page_views_last_month_log\" : 6.569855608330948,\n                \"page_views_total_log\" : 12.239300174364203\n              },\n            \"columns_name\" :\n              [\n                \"Routes\",\n                \"Nearest Intersection\",\n                \"Latitude\",\n                \"Description\",\n                \"Location (address)\",\n                \"Location (zip)\",\n                \"NYS Municipal Boundaries\",\n                \"New York Zip Codes\",\n                \"Counties\",\n                \"Location (city)\",\n                \"Location (state)\",\n                \"Location\",\n                \"Info Booth\",\n                \"Bench\",\n                \"Longitude\",\n                \"Signpost\",\n                \"Bikerack\",\n                \"Municipality\",\n                \"Stop ID\",\n                \"Shelter\",\n                \"Discontinued\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"routes\",\n                \"nearest_intersection\",\n                \"latitude\",\n                \"description\",\n                \"location_address\",\n                \"location_zip\",\n                \":@computed_region_yamh_8v7k\",\n                \":@computed_region_wbg7_3whc\",\n                \":@computed_region_kjdx_g34t\",\n                \"location_city\",\n                \"location_state\",\n                \"location\",\n                \"info_booth\",\n                \"bench\",\n                \"longitude\",\n                \"signpost\",\n                \"bikerack\",\n                \"municipality\",\n                \"stop_id\",\n                \"shelter\",\n                \"discontinued\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Point\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Routes that service stop\",\n                \"Nearest intersection to stop\",\n                \"Latitude of Stop\",\n                \"Stop Description\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"Does stop have an info booth\",\n                \"Does stop have a bench\",\n                \"Longitude of Stop\",\n                \"Does stop have a sign (Discontinued Stops will not have)\",\n                \"Does stop have bike rack\",\n                \"Municipality where stop is located\",\n                \"Unique ID associated to stop located on sign. Can be used for obtaining stop schedule information through cdta.org or customer service\",\n                \"Does stop have a shelter\",\n                \"Is stop Discontinued\"\n              ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"precisionStyle\" : \"standard\", \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                { \"align\" : \"left\" },\n                { \"align\" : \"center\" },\n                { \"align\" : \"center\" },\n                { \"precisionStyle\" : \"standard\", \"align\" : \"left\" },\n                { \"align\" : \"center\" },\n                { \"align\" : \"center\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"center\" },\n                { \"align\" : \"center\" },\n                { \"align\" : \"center\" }\n              ],\n            \"download_count\" : 4424,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2019-04-08T16:25:48.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"bus\", \"cdta\", \"routes\", \"stops\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Common-Core_Publisher\",\n                  \"value\" : \"State of New York\"\n                },\n                {\n                  \"key\" : \"Common-Core_Contact-Name\",\n                  \"value\" : \"Open Data NY\"\n                },\n                {\n                  \"key\" : \"Common-Core_Contact-Email\",\n                  \"value\" : \"opendata@its.ny.gov\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Dataset-Owner\",\n                  \"value\" : \"Planning and Scheduling\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Contact-Information\",\n                  \"value\" : \"KenG@CDTA.org\"\n                },\n                { \"key\" : \"Dataset-Summary_Granularity\", \"value\" : \"Region\" },\n                {\n                  \"key\" : \"Dataset-Summary_Coverage\",\n                  \"value\" : \"Capital Region\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Data-Frequency\",\n                  \"value\" : \"Annually\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Posting-Frequency\",\n                  \"value\" : \"Annually\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Organization\",\n                  \"value\" : \"Capital District Transportation Authority\"\n                },\n                { \"key\" : \"Local-Data_Municipality-Filter\", \"value\" : \"Yes\" },\n                {\n                  \"key\" : \"Local-Data_Municipality_Column\",\n                  \"value\" : \"municipality\"\n                },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Capital District Transit Authority\"\n                },\n                {\n                  \"key\" : \"Disclaimers_Limitations\",\n                  \"value\" : \"This information is not continuously updated. As such, any information reported represents a specific snapshot in time.\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.ny.gov\" },\n        \"permalink\" : \"https://data.ny.gov/d/wgnh-hpq9\",\n        \"link\" : \"https://data.ny.gov/Transportation/Capital-District-Bus-Stops/wgnh-hpq9\",\n        \"owner\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Bus Routes\",\n            \"id\" : \"s5c7-gtgi\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"\",\n            \"attribution\" : null,\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2015-05-23T02:10:06.000Z\",\n            \"createdAt\" : \"2015-05-23T02:08:05.000Z\",\n            \"metadata_updated_at\" : \"2015-05-23T02:10:06.000Z\",\n            \"data_updated_at\" : \"2015-05-23T02:08:18.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 19,\n                \"page_views_last_month\" : 41,\n                \"page_views_total\" : 1561,\n                \"page_views_last_week_log\" : 4.321928094887363,\n                \"page_views_last_month_log\" : 5.392317422778761,\n                \"page_views_total_log\" : 10.60917873814198\n              },\n            \"columns_name\" :\n              [\n                \"route_id\",\n                \"route_long_name\",\n                \"route_url\",\n                \"agency_id\",\n                \"route_color\",\n                \"route_text_color\",\n                \"route_short_name\",\n                \"route_desc\",\n                \"route_type\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"route_id\",\n                \"route_long_name\",\n                \"route_url\",\n                \"agency_id\",\n                \"route_color\",\n                \"route_text_color\",\n                \"route_short_name\",\n                \"route_desc\",\n                \"route_type\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\"\n              ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" : [ {}, {}, {}, {}, {}, {}, {}, {}, {} ],\n            \"download_count\" : 2835,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2015-05-23T02:08:46.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [],\n            \"domain_metadata\" : []\n          },\n        \"metadata\" : { \"domain\" : \"data.honolulu.gov\" },\n        \"permalink\" : \"https://data.honolulu.gov/d/s5c7-gtgi\",\n        \"link\" : \"https://data.honolulu.gov/Transportation/Bus-Routes/s5c7-gtgi\",\n        \"owner\" :\n          {\n            \"id\" : \"b4zr-4dtj\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Karl Sueyoshi\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"b4zr-4dtj\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Karl Sueyoshi\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Bus Ridership\",\n            \"id\" : \"nmjv-498y\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"***NOTE: There are problems with data accuracy on bus ridership counts for June 2019, July 2019, and August 2019 as Phoenix and Valley Metro attempt to integrate new hardware with the existing system. For Mesa this is clearly impacting routes 156, 531, and 541, however, there are minor anomalies with some of the other routes. \\n\\nBreakdown of bus service ridership on a monthly basis per route in Mesa (data lags for approximately 30 days) and data is provided by Valley Metro, an external agency who is responsible for both bus service and light rail in Mesa. For a regional view of both bus service and light rail ridership, please go to their website, under their Publications/Reports section. Valley Metro tracks bus riders as they board. Bus service expands the scope and range of light rail, in addition to being a geographically more flexible means of public transportation in comparison to light rail. \\n\\nThe data set captures information starting in July 2013. Effective October 24, 2016, AZ Link has been consolidated with route 112, and the Main Street Link consolidated with route 40.\\n\\nData reporting can be delayed up to 60 days.\",\n            \"attribution\" : \"Transit Services\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-17T23:31:18.000Z\",\n            \"createdAt\" : \"2019-06-03T17:34:05.000Z\",\n            \"metadata_updated_at\" : \"2025-07-17T23:31:17.000Z\",\n            \"data_updated_at\" : \"2025-07-17T23:31:18.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 3,\n                \"page_views_last_month\" : 3,\n                \"page_views_total\" : 527,\n                \"page_views_last_week_log\" : 2.0,\n                \"page_views_last_month_log\" : 2.0,\n                \"page_views_total_log\" : 9.044394119358454\n              },\n            \"columns_name\" :\n              [\n                \"Month Date\",\n                \"Month\",\n                \"Route\",\n                \"Calendar Year\",\n                \"Fiscal Year\",\n                \"Row ID\",\n                \"Riders\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"month_date\",\n                \"month\",\n                \"route\",\n                \"calendar_year\",\n                \"fiscal_year\",\n                \"row_id\",\n                \"riders\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"The month and year in which bus riders were measured\",\n                \"Month for which bus riders were measured\",\n                \"Route number of the bus for which riders were measured. See www.valleymetro.org for specific bus route map and other detailed route information.\",\n                \"Calendar year in which bus riders were measured\",\n                \"Fiscal year in which bus riders were measured\",\n                \"This is derived by combining Month, Calendar year and Bus Route Number\",\n                \"The number of riders per route per month\"\n              ],\n            \"columns_format\" : [ { \"view\" : \"date\" }, {}, {}, {}, {}, {}, {} ],\n            \"download_count\" : 78,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2021-02-16T22:55:57.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transit Services\",\n            \"domain_tags\" :\n              [ \"bus\", \"downtown\", \"ridership\", \"route\", \"valley metro\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Frequency_Publishing\", \"value\" : \"Monthly\" },\n                { \"key\" : \"Frequency_Data-Change\", \"value\" : \"Monthly\" },\n                {\n                  \"key\" : \"Frequency_Scheduled-Data-Update\",\n                  \"value\" : \"Manual Post\"\n                },\n                {\n                  \"key\" : \"Data-Quality_Max-Expected-Data-Age\",\n                  \"value\" : \"90\"\n                },\n                {\n                  \"key\" : \"Terms-of-Use_Terms-of-Use\",\n                  \"value\" : \"https://data.mesaaz.gov/stories/s/2dcd-j2nx/\"\n                }\n              ]\n          },\n        \"metadata\" :\n          { \"domain\" : \"citydata.mesaaz.gov\", \"license\" : \"See Terms of Use\" },\n        \"permalink\" : \"https://citydata.mesaaz.gov/d/nmjv-498y\",\n        \"link\" : \"https://citydata.mesaaz.gov/Transit-Services/Bus-Ridership/nmjv-498y\",\n        \"owner\" :\n          {\n            \"id\" : \"pxyu-mdaq\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"City of Mesa\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"pxyu-mdaq\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"City of Mesa\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Bus Lanes - Local Streets\",\n            \"id\" : \"ycrg-ses3\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Bus lanes are travel lanes that are restricted to buses during certain hours of the day. All bus lanes have signs posted along the route with specific regulations; lanes marked \\\"Bus Only\\\" and /or painted red. Bus lanes help to keep buses from getting stuck in traffic, generally making travel for bus riders faster and reliable and improving the overall traffic flow of a corridor. Each record represents a segment of a bus lane based on the LION geographic base file of NYC streets. User may use the SegmentID field in this dataset to join with the LION data for more information.\",\n            \"attribution\" : \"Department of Transportation (DOT)\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2024-05-24T16:46:49.000Z\",\n            \"createdAt\" : \"2020-12-04T21:06:13.000Z\",\n            \"metadata_updated_at\" : \"2024-05-24T16:46:49.000Z\",\n            \"data_updated_at\" : \"2024-05-24T16:46:42.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 43,\n                \"page_views_last_month\" : 155,\n                \"page_views_total\" : 6604,\n                \"page_views_last_week_log\" : 5.459431618637297,\n                \"page_views_last_month_log\" : 7.285402218862249,\n                \"page_views_total_log\" : 12.68934284613419\n              },\n            \"columns_name\" :\n              [\n                \"Open_dates\",\n                \"Lane_Type1\",\n                \"Year3\",\n                \"Hours\",\n                \"Last_Updat\",\n                \"Shape_Leng\",\n                \"Street\",\n                \"Chron_ID_1\",\n                \"StreetWidt\",\n                \"Year1\",\n                \"SegmentID\",\n                \"Days\",\n                \"Lane_width\",\n                \"Facility\",\n                \"Year2\",\n                \"SBS_Route2\",\n                \"Lane_Type2\",\n                \"SBS_Route1\",\n                \"SBS_Route3\",\n                \"Shape_Le_1\",\n                \"Boro\",\n                \"Lane_Color\",\n                \"RW_TYPE\",\n                \"Days_Code\",\n                \"TrafDir\",\n                \"the_geom\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"open_dates\",\n                \"lane_type1\",\n                \"year3\",\n                \"hours\",\n                \"last_updat\",\n                \"shape_leng\",\n                \"street\",\n                \"chron_id_1\",\n                \"streetwidt\",\n                \"year1\",\n                \"segmentid\",\n                \"days\",\n                \"lane_width\",\n                \"facility\",\n                \"year2\",\n                \"sbs_route2\",\n                \"lane_type2\",\n                \"sbs_route1\",\n                \"sbs_route3\",\n                \"shape_le_1\",\n                \"boro\",\n                \"lane_color\",\n                \"rw_type\",\n                \"days_code\",\n                \"bltrafdir\",\n                \"the_geom\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"MultiLine\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"MultiLine\"\n              ],\n            \"columns_description\" :\n              [\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\"\n              ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                { \"noCommas\" : \"true\" },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 2267,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2024-05-24T16:46:49.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"bus\", \"lanes\", \"mta\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Update_Automation\", \"value\" : \"No\" },\n                { \"key\" : \"Update_Date-Made-Public\", \"value\" : \"12/7/2020\" },\n                { \"key\" : \"Update_Update-Frequency\", \"value\" : \"Annually\" },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Department of Transportation (DOT)\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofnewyork.us\" },\n        \"permalink\" : \"https://data.cityofnewyork.us/d/ycrg-ses3\",\n        \"link\" : \"https://data.cityofnewyork.us/Transportation/Bus-Lanes-Local-Streets/ycrg-ses3\",\n        \"owner\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"MTA Bus Speeds: 2015-2019\",\n            \"id\" : \"cudb-vcni\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Bus Speeds measure how quickly buses travel along their routes. This dataset covers data between 2015 and 2019. For data from 2020 on, use https://data.ny.gov/Transportation/MTA-Bus-Speeds-Beginning-2020/6ksi-7cxr.\",\n            \"attribution\" : \"Metropolitan Transportation Authority\",\n            \"attribution_link\" : \"https://www.mta.info/open-data\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2024-08-26T15:20:42.000Z\",\n            \"createdAt\" : \"2021-12-29T18:11:07.000Z\",\n            \"metadata_updated_at\" : \"2024-08-26T15:20:42.000Z\",\n            \"data_updated_at\" : \"2024-08-26T15:20:35.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 70,\n                \"page_views_last_month\" : 209,\n                \"page_views_total\" : 4746,\n                \"page_views_last_week_log\" : 6.149747119504682,\n                \"page_views_last_month_log\" : 7.714245517666122,\n                \"page_views_total_log\" : 12.212800334429433\n              },\n            \"columns_name\" :\n              [\n                \"trip_type\",\n                \"average_speed\",\n                \"total_mileage\",\n                \"total_operating_time\",\n                \"route_id\",\n                \"borough\",\n                \"month\",\n                \"period\",\n                \"day_type\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"trip_type\",\n                \"average_speed\",\n                \"total_mileage\",\n                \"total_operating_time\",\n                \"route_id\",\n                \"borough\",\n                \"month\",\n                \"period\",\n                \"day_type\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"The type of bus service provided: EXP (Express), LCL/LTD (Local/Limited), SBS (Select Bus Service).\",\n                \"The average speed is based on the total operating time and total mileage, per bus route, per month.\",\n                \"The total operating time for each bus route, monthly, during peak and off-peak hours.\",\n                \"The total mileage for each bus route, monthly, during peak and off-peak hours.\",\n                \"Identifies each individual bus route, as well as cumulative totals for all bus routes (identified as ALL).\",\n                \"Represents the five boroughs of New York City (Bronx, Brooklyn, Manhattan, Queens, Staten Island).\",\n                \"Represents the time period in which the average speed is being calculated (yyyy-mm-dd).\",\n                \"Represents both the peak and off-peak service periods.\",\n                \" Represents 1 as weekday and 2 as weekend.\"\n              ],\n            \"columns_format\" :\n              [\n                {},\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {},\n                {},\n                { \"view\" : \"iso_8601_date\", \"align\" : \"center\" },\n                {},\n                {}\n              ],\n            \"download_count\" : 6485,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2024-08-26T15:20:41.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"average speed\",\n                \"bus\",\n                \"bus route\",\n                \"delays\",\n                \"monthly\",\n                \"mtabc\",\n                \"mta bus\",\n                \"new york city transit\",\n                \"nyct\",\n                \"performance\",\n                \"route\",\n                \"service\",\n                \"speeds\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Dataset-Summary_Dataset-Owner\",\n                  \"value\" : \"Metropolitan Transportation Authority\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Contact-Information\",\n                  \"value\" : \"OpenData@mtahq.org\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Granularity\",\n                  \"value\" : \"Bus route, month, borough, day type, trip type\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Coverage\",\n                  \"value\" : \"New York City and parts of Nassau, Hudson and Westchester counties\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Posting-Frequency\",\n                  \"value\" : \"Static - Not Updated\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Organization\",\n                  \"value\" : \"New York City Transit, MTA Bus Company\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Time-Period\",\n                  \"value\" : \"2015-2019\"\n                },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Metropolitan Transportation Authority\"\n                },\n                {\n                  \"key\" : \"Additional-Resources_See-Also\",\n                  \"value\" : \"http://metrics.mta.info/\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.ny.gov\" },\n        \"permalink\" : \"https://data.ny.gov/d/cudb-vcni\",\n        \"link\" : \"https://data.ny.gov/Transportation/MTA-Bus-Speeds-2015-2019/cudb-vcni\",\n        \"owner\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Bus Routes\",\n            \"id\" : \"ifm8-78yv\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset provides the shape file of physical paths taken by vehicles in the ACT. This file is generated using the GTFS data as of May 2020. Please refer to latest GTFS data published at https://www.transport.act.gov.au/contact-us/information-for-developers\",\n            \"attribution\" : \"Transport Canberra\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2021-11-26T02:22:56.000Z\",\n            \"createdAt\" : \"2020-05-14T06:13:27.000Z\",\n            \"metadata_updated_at\" : \"2021-11-26T02:22:56.000Z\",\n            \"data_updated_at\" : \"2020-05-14T06:17:51.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 5,\n                \"page_views_last_month\" : 59,\n                \"page_views_total\" : 1079,\n                \"page_views_last_week_log\" : 2.584962500721156,\n                \"page_views_last_month_log\" : 5.906890595608519,\n                \"page_views_total_log\" : 10.076815597050832\n              },\n            \"columns_name\" :\n              [\n                \"Id\",\n                \"route_desc\",\n                \"route_url\",\n                \"long_name\",\n                \"short_name\",\n                \"route_id\",\n                \"shape_id\",\n                \"color\",\n                \"the_geom\",\n                \"text_color\",\n                \"route_type\",\n                \"rt_tp_txt\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"id\",\n                \"route_desc\",\n                \"route_url\",\n                \"long_name\",\n                \"short_name\",\n                \"route_id\",\n                \"shape_id\",\n                \"color\",\n                \"the_geom\",\n                \"text_color\",\n                \"route_type\",\n                \"rt_tp_txt\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"MultiLine\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [ \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {} ],\n            \"download_count\" : 1247,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2020-05-14T06:17:52.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transport\",\n            \"domain_tags\" : [ \"routes\", \"bus\", \"shape file\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Contributing-Agency_Agency-Name\",\n                  \"value\" : \"Transport Canberra\"\n                },\n                {\n                  \"key\" : \"Contributing-Agency_Directorate\",\n                  \"value\" : \"Transport Canberra and City Services\"\n                },\n                {\n                  \"key\" : \"Contributing-Agency_Contact-Email\",\n                  \"value\" : \"tccs.datacapability@act.gov.au\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"www.data.act.gov.au\",\n            \"license\" : \"Creative Commons Attribution 4.0 International\"\n          },\n        \"permalink\" : \"https://www.data.act.gov.au/d/ifm8-78yv\",\n        \"link\" : \"https://www.data.act.gov.au/Transport/Bus-Routes/ifm8-78yv\",\n        \"owner\" :\n          {\n            \"id\" : \"m7km-7fxa\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"TCCS\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"m7km-7fxa\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"TCCS\"\n          }\n      }\n    ],\n  \"resultSetSize\" : 875,\n  \"timings\" : { \"serviceMillis\" : 44, \"searchMillis\" : [ 5, 11 ] },\n  \"warnings\" : []\n}"), 
    timing = c(redirect = 0, namelookup = 1.1e-05, connect = 0, 
    pretransfer = 6.2e-05, starttransfer = 0.100701, total = 0.101512
    ), cache = new.env(parent = emptyenv())), class = "httr2_response")
