% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sominp.R
\name{sominp}
\alias{sominp}
\title{Create sominp object}
\usage{
sominp(x)
}
\arguments{
\item{x}{The \code{data.table} object which will be tranformed to \code{somsp} object.}
}
\value{
A \code{sominp} object. It contains:

\itemize{

\item{a \code{matrix} that can be used as input for the \code{som} function of
the \verb{kohonen package}.}

\item{a \code{data.table} with the with spatial point coordinates and a corresponding id.}

\item{a \code{data.table} with the original dataset.}
}
}
\description{
\code{sominp} transforms the data set from \code{data.table} to
\code{somsp} format, which can be used as argument in the \code{somspa} function.
}
\details{
\code{x} should be in tidy format
with four columns: time, latitude, longitude and variable.
}
\examples{


\donttest{
dummy <- owda[Time <= 1510]
inp_som <- sominp(dummy)}

}
\seealso{
\code{\link{somspa}}
}
