% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_spark.R
\name{copy_to.spark_connection}
\alias{copy_to.spark_connection}
\title{Copy an R Data Frame to Spark}
\usage{
\method{copy_to}{spark_connection}(
  dest,
  df,
  name = spark_table_name(substitute(df)),
  overwrite = FALSE,
  memory = TRUE,
  repartition = 0L,
  ...
)
}
\arguments{
\item{dest}{A \code{spark_connection}.}

\item{df}{An \R \code{data.frame}.}

\item{name}{The name to assign to the copied table in Spark.}

\item{overwrite}{Boolean; overwrite a pre-existing table with the name \code{name}
if one already exists?}

\item{memory}{Boolean; should the table be cached into memory?}

\item{repartition}{The number of partitions to use when distributing the
table across the Spark cluster. The default (0) can be used to avoid
partitioning.}

\item{...}{Optional arguments; currently unused.}
}
\value{
A \code{tbl_spark}, representing a \code{dplyr}-compatible interface
  to a Spark DataFrame.
}
\description{
Copy an R \code{data.frame} to Spark, and return a reference to the
generated Spark DataFrame as a \code{tbl_spark}. The returned object will
act as a \code{dplyr}-compatible interface to the underlying Spark table.
}
