% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_from_names.R
\name{label_from_names}
\alias{label_from_names}
\title{Derive variable labels from column names \verb{name<sep>label}}
\usage{
label_from_names(df, sep = ". ")
}
\arguments{
\item{df}{A \code{data.frame} or tibble with column names of the form
\verb{"name<sep>label"} (e.g. "name. label"). (by default from LimeSurvey).}

\item{sep}{Character string used as separator between name and label.
Default is \code{". "} (LimeSurvey's default), but any literal string can be used.}
}
\value{
A base \code{tibble} with column names equal to the \emph{names} (before \code{sep})
and \code{var_label} attributes equal to the \emph{labels} (after \code{sep}).
}
\description{
Splits each column name at the \strong{first} occurrence of \code{sep}, renames
the column to the part before \code{sep} (the \emph{name}), and assigns the part
after \code{sep} as a \code{\link[labelled:var_label]{labelled::var_label()}}. This works even if the label
itself contains the separator.
}
\details{
This function is especially useful for \strong{LimeSurvey CSV exports} when using
\emph{Export results} → \emph{Export format: CSV} → \emph{Headings: Question code & question text},
where column names look like \code{"code. question text"}. In this case the
default separator is \code{". "}.
}
\examples{
# Example with LimeSurvey-style column names
df <- data.frame(
  "age. Age of respondent" = c(25, 30),
  "score. Total score. Manually computed." = c(12, 14),
  check.names = FALSE
)

# sep = ". " by default (LimeSurvey)
out <- label_from_names(df)
labelled::var_label(out)

# Example with a custom separator ("|")
df2 <- data.frame(
  "id|Identifier" = 1:3,
  "score|Total score" = c(10, 20, 30),
  check.names = FALSE
)
out2 <- label_from_names(df2, sep = "|")
labelled::var_label(out2)

}
