% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-football.R
\name{football_field_apron}
\alias{football_field_apron}
\title{The field should have an apron to appropriately see all out-of-bounds
features. This is typically the same color as the field itself, but will be
created separately so as to allow for more customized plotting}
\usage{
football_field_apron(
  field_length = 0,
  field_width = 0,
  endzone_length = 0,
  boundary_thickness = 0,
  field_border_thickness = 0,
  restricted_area_length = 0,
  restricted_area_width = 0,
  coaching_box_length = 0,
  coaching_box_width = 0,
  team_bench_length_field_side = 0,
  team_bench_length_back_side = 0,
  team_bench_width = 0,
  team_bench_area_border_thickness = 0,
  extra_apron_padding = 0,
  bench_shape = ""
)
}
\arguments{
\item{field_length}{The length of the field}

\item{field_width}{The width of the field}

\item{endzone_length}{The length of the endzone}

\item{boundary_thickness}{The thickness of the field boundary}

\item{field_border_thickness}{The thickness of the field border}

\item{restricted_area_length}{The length of the restricted area}

\item{restricted_area_width}{The width of the restricted area}

\item{coaching_box_length}{The length of the coaching box}

\item{coaching_box_width}{The width of the coaching box}

\item{team_bench_length_field_side}{The length of the team bench area nearest
the field}

\item{team_bench_length_back_side}{The length of the team bench area furthest
from the field}

\item{team_bench_width}{The width of the team bench area}

\item{team_bench_area_border_thickness}{The thickness of the border around
the team bench area}

\item{extra_apron_padding}{Any additional distance to add to the apron of the
field}

\item{bench_shape}{A string of the shape of the bench. Currently, this checks
for \code{"rectangle"}}
}
\value{
A data frame of the bounding coordinates of the field apron
}
\description{
The field should have an apron to appropriately see all out-of-bounds
features. This is typically the same color as the field itself, but will be
created separately so as to allow for more customized plotting
}
\keyword{internal}
