% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-soccer.R
\name{soccer_penalty_box}
\alias{soccer_penalty_box}
\title{The penalty box on the pitch is the larger of the two boxes that extend from
the goal line. The penalty box is usually 16.5 meters (18 yards) from the
goal line, but may be parameterized via this function}
\usage{
soccer_penalty_box(
  feature_radius = 0,
  feature_thickness = 0,
  box_length = 0,
  penalty_mark_dist = 0,
  goal_width = 0,
  goal_post_to_box_edge = 0
)
}
\arguments{
\item{feature_radius}{The radius of the circle at the top of the penalty box}

\item{feature_thickness}{The thickness of the penalty box}

\item{box_length}{The length of the penalty box (from the goal line)}

\item{penalty_mark_dist}{The distance from the back edge of the goal line to
the penalty mark}

\item{goal_width}{The interior width of the goal}

\item{goal_post_to_box_edge}{The distance from the interior of the goal post
to the outer edge of the penalty box}
}
\value{
A data frame containing the bounding coordinates of the penalty box
}
\description{
This draws a half-box, which will include the circular portion at the top of
the box. All dimensions given should be to the outside of the features
}
\details{
The line thickness will be uniform for all features on the pitch
}
\keyword{internal}
