% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{hexLogo}
\alias{hexLogo}
\alias{hexPanel}
\title{Hexagon logo and logo panel}
\usage{
hexLogo(
  id,
  title = "",
  hex_img,
  hex_link = "",
  footer = "",
  footer_link = "",
  x = "-10",
  y = "-20",
  target_blank = FALSE
)

hexPanel(
  id,
  title,
  hex_imgs,
  hex_links = NULL,
  hex_titles = NULL,
  footers = NULL,
  footer_links = NULL,
  xs = NULL,
  ys = NULL,
  target_blank = FALSE
)
}
\arguments{
\item{id}{input ID}

\item{title}{title of the logo, display on top of logo or title of logo panel
displayed on the left}

\item{hex_img}{single value of \code{hex_imgs}}

\item{hex_link}{single value of \code{hex_links}}

\item{footer}{single value of \code{footers}}

\item{footer_link}{single value of \code{footer_links}}

\item{x}{number, X offset, e.g. "-10" instead of -10L}

\item{y}{number, Y offset}

\item{target_blank}{bool, whether to add \code{target="_blank"} to the link?}

\item{hex_imgs}{a character vector of logo image source, can be online or
local, see details}

\item{hex_links}{a character vector of links attached to each logo, if not
\code{NULL}, must be the same length as \code{hex_imgs}}

\item{hex_titles}{similar to \code{hex_links}, titles of each logo}

\item{footers}{a character vector of footer attached to each logo}

\item{footer_links}{a character vector of footer links, if not \code{NULL},
must be the same length as \code{footers}}

\item{xs}{a character vector X coordinate offset value for each logo image,
default -10, mist be the same length as \code{hex_imgs}}

\item{ys}{Y coordinates offset, must be the same length as \code{xs}, default -20}
}
\value{
HTML elements, tagList
}
\description{
Shiny UI widgets to generate hexagon logo(s).
\code{\link[=hexLogo]{hexLogo()}} generates a single hexagon, and \code{\link[=hexPanel]{hexPanel()}}
generates a panel of hex logos
}
\details{
The image in each hexagon is resized to the same size as the hex border
and then enlarged 125\%. You may want to use x, y offset value to change
the image position.

If your image source is local, you need to add your local directory to the
shiny server, e.g. \code{addResourcePath("sps", "www")}. This example add \code{www}
folder under my current working directory as \code{sps} to the server. Then you
can access my images by \code{hex_imgs = "sps/my_img.png"}.

some args in \code{hexPanel} are character vectors, use \code{NULL} for the default
value. If you want to change value but not all of your logos, use \code{""} to
occupy space in the vector. e.g. I have 3 logos, but I only want to add
2 footer and only 1 footer has a link:
\code{footers = c("footer1", "footer2", "")},
\code{footer_links = c("", "https://mylink", "")}. By doing so  \code{footers} and
\code{footer_links} has the same required length.
}
\examples{
if(interactive()){
    ui <- fluidPage(
        hexLogo(
            "logo", "Logo",
            hex_img = "https://live.staticflickr.com/7875/46106952034_954b8775fa_b.jpg",
            hex_link = "https://www.google.com",
            footer = "Footer",
            footer_link = "https://www.google.com"
        ),
        hexLogo(
            "x", "Change X offset",
            hex_img = "https://live.staticflickr.com/7875/46106952034_954b8775fa_b.jpg",
            x = "40"
        ),
        hexLogo(
            "y", "Change Y offset",
            hex_img = "https://live.staticflickr.com/7875/46106952034_954b8775fa_b.jpg",
            y = "-60"
        ),
        hexPanel(
            "demo1", "basic panel:" ,
            rep("https://live.staticflickr.com/7875/46106952034_954b8775fa_b.jpg", 2)

        ),
        hexPanel(
            "demo2", "panel with links:" ,
            c(paste0("https://d33wubrfki0l68.cloudfront.net/",
              "2c6239d311be6d037c251c71c3902792f8c4ddd2/12f67/css/images/hex/ggplot2.png"),
              paste0("https://d33wubrfki0l68.cloudfront.net/",
              "621a9c8c5d7b47c4b6d72e8f01f28d14310e8370/193fc/css/images/hex/dplyr.png")
            ),
            c("https://ggplot2.tidyverse.org/", "https://dplyr.tidyverse.org/"),
            c("ggplot2", "dplyr")
        ),
        hexPanel(
            "demo3", "footer with links:" ,
            rep("https://live.staticflickr.com/7875/46106952034_954b8775fa_b.jpg", 2),
            footers = c("hex1", "hex2"),
            footer_links = rep("https://www.google.com", 2)
        ),
        hexPanel(
            "demo4", "panel offsets" ,
            hex_imgs = rep("https://live.staticflickr.com/7875/46106952034_954b8775fa_b.jpg", 4),
            footers = paste0("hex", 1:4),
            ys = seq(-20, -50, by = -10),
            xs = seq(20, 50, by = 10)
        )
    )
    server <- function(input, output, session) {
    }
    shinyApp(ui, server)
}
}
