% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCA_helpers.R
\name{explained_var}
\alias{explained_var}
\title{Explained Variance summarized over Groups}
\usage{
explained_var(COVS, PC, k, type = "scaled", cor = FALSE, gamma = 0.5)
}
\arguments{
\item{COVS}{list of covariance matrices}

\item{PC}{matrix-like object holding the loadings of length np}

\item{k}{which component should be evaluated}

\item{type}{character, either \code{"scaled"} for scaling using the extremes solutions or \code{"percent"} as percentage of overall variance.}

\item{cor}{logical, if \code{COVS} is a correlation matrix or not}

\item{gamma}{scalar between 0 and 1 indicatig distribution of sparsity.}
}
\value{
Returns scalar
}
\description{
Explained Variance summarized over Groups
}
\examples{
S1 = matrix(c(1, 0.9, 0.8, 0.5,
              0.9, 1.1, 0.7, 0.4,
              0.8, 0.7, 1.5, 0.2,
              0.5, 0.4, 0.2, 1), ncol = 4)
S2 = t(S1)\%*\% S1
S2 = S2/2

explained_var(COVS = list(S1, S2),
              PC = c(1,0,0,0,sqrt(2),0,0,-sqrt(2)),
              k = 1,
              cor = FALSE,
              gamma = 0.5)

explained_var(COVS = list(cov2cor(S1), cov2cor(S2)),
              PC = c(1,0,0,0,sqrt(2),0,0,-sqrt(2)),
              k = 1,
              cor = TRUE,
              gamma = 0.5)
}
