# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

objective <- function(X, mu, Sigma, pi_groups, W, groups, Q) {
    .Call('_ssMRCD_objective', PACKAGE = 'ssMRCD', X, mu, Sigma, pi_groups, W, groups, Q)
}

w_step <- function(X, mu, Sigma, pi_groups, W, groups, Q, h) {
    .Call('_ssMRCD_w_step', PACKAGE = 'ssMRCD', X, mu, Sigma, pi_groups, W, groups, Q, h)
}

probabs <- function(X, mu, Sigma, pi_groups, W, groups) {
    .Call('_ssMRCD_probabs', PACKAGE = 'ssMRCD', X, mu, Sigma, pi_groups, W, groups)
}

pis <- function(probs, groups, alpha = 0.5) {
    .Call('_ssMRCD_pis', PACKAGE = 'ssMRCD', probs, groups, alpha)
}

#' @title Regularized Covariance Matrix Calculation
#' @description Computes a regularized covariance matrix using a convex combination of a target matrix and the sample covariance matrix.
#' @name RCOV
#'
#' @param XX A numeric matrix containing the observations, where each column represents a different observation.
#' @param vMu A numeric vector representing the mean vector to center the columns of \code{XX}.
#' @param rho A numeric scalar representing the regularization parameter (between 0 and 1) that balances between the target matrix and the sample covariance.
#' @param mT A numeric matrix representing the target covariance matrix for regularization.
#' @param scfac A numeric scalar representing a scaling factor applied to the sample covariance matrix.
#'
#' @return A named list containing:
#'   \item{rho}{The regularization parameter used in the calculation.}
#'   \item{mT}{The target covariance matrix provided as input.}
#'   \item{cov}{The sample covariance matrix calculated from the centered observations.}
#'   \item{rcov}{The regularized covariance matrix, which is a convex combination of the target matrix and scaled sample covariance matrix.}
#'
#' @details The function calculates the sample covariance matrix of the centered data \code{XX} and combines it with the target covariance matrix \code{mT}, scaled by the factor \code{scfac}. The regularization is controlled by the parameter \code{rho}, where \code{rho = 1} results in using only the target matrix, and \code{rho = 0} uses only the sample covariance.
#'
#' @importFrom Rcpp sourceCpp
#' @keywords internal
NULL

RCOV <- function(XX, vMu, rho, mT, scfac) {
    .Call('_ssMRCD_RCOV', PACKAGE = 'ssMRCD', XX, vMu, rho, mT, scfac)
}

#' @title Calculation of Objective Function
#' @description Calculation of the value of the objective function for a given list of matrices,
#' lambda, and a weighting matrix.
#' @param matrix_list A list of matrices \eqn{K_i}.
#' @param lambda Scalar smoothing parameter.
#' @param weights Matrix of weights.
#' @return Returns the value of the objective function.
#' @name objective_matrix
#' @keywords internal
objective_matrix <- function(matrix_list, lambda, weights) {
    .Call('_ssMRCD_objective_matrix', PACKAGE = 'ssMRCD', matrix_list, lambda, weights)
}

#' @title Objective Function for Init Object
#' @description Calculates the objective function based on the matrices stored in the init object.
#' @param init_object List object containing matrices
#' @param lambda Scalar for spatial smoothing
#' @param weights Matrix with weights
#' @return Returns the value of the objective function.
#' @keywords internal
objective_init <- function(init_object, lambda, weights) {
    .Call('_ssMRCD_objective_init', PACKAGE = 'ssMRCD', init_object, lambda, weights)
}

#' Computes Mahalanobis Distances for a Given Set of H-Subsets
#'
#' This function calculates the Mahalanobis distances for a set of observations
#' by centering them with the mean vector and using a covariance matrix computed
#' as a weighted combination of the covariance matrix of the current item and
#' the covariance matrices of its neighbors.
#'
#' @param init A list of items where each item contains the following elements:
#'   \itemize{
#'     \item \code{mX} A matrix of observations (one column per observation).
#'     \item \code{vMu} A vector of means.
#'     \item \code{mS} A covariance matrix of the observations in \code{mX}.
#'   }
#' @param i An integer index specifying which item from the \code{init} list to use.
#' @param lambda A numeric value representing the weight for the covariance matrix of the current item.
#' @param weights A matrix of weights where each element \code{weights(i, j)} specifies the weight of the \code{j}-th item for the \code{i}-th item.
#'
#' @return A numeric vector of distances for each observation in the centered matrix.
#'
#' @details The Mahalanobis distances are computed using the covariance matrix,
#' which is a weighted combination of the current item's covariance matrix and
#' those of its neighbors. The covariance matrix is smoothed using the parameter
#' \code{lambda} and the distances are computed as \code{(x_centered^T * Cov_matrix_chol_inv * x_centered)} for each observation.
#'
#' @keywords internal
dist_cstep <- function(init, i, lambda, weights) {
    .Call('_ssMRCD_dist_cstep', PACKAGE = 'ssMRCD', init, i, lambda, weights)
}

#' Perform Concentration Step
#'
#' This function performs concentration steps by iteratively updating
#' the neighborhoods of items based on Mahalanobis distances. The function computes
#' the covariance matrix and updates the neighborhood list until convergence or
#' a maximum number of iterations is reached.
#'
#' @param init A list of items where each item contains:
#'   \itemize{
#'     \item \code{mX} A matrix of observations (one column per observation).
#'     \item \code{hsets.init} A matrix where each column specifies initial indices for neighbors.
#'     \item \code{rho} A regularization parameter for covariance estimation.
#'     \item \code{scfac} A scaling factor for consistency.
#'     \item \code{mS} A covariance matrix of the observations in \code{mX}.
#'     \item \code{index} (Initially not present; will be updated with indices of neighbors).
#'     \item \code{vdst} (Initially not present; will be updated with Mahalanobis distances).
#'     \item \code{stop} (Initially not present; used to indicate convergence).
#'     \item \code{ret} (Initially not present; will be updated with results from \code{RCOV}).
#'   }
#' @param maxcsteps An integer specifying the maximum number of iterations for the optimization.
#' @param which_indices An integer vector specifying which initial indices to use for each item.
#' @param lambda A numeric value representing the weight for the covariance matrix in the optimization.
#' @param weights A matrix of weights where each element \code{weights(i, j)} specifies the weight of the \code{j}-th item for the \code{i}-th item.
#' @param mT A matrix used for regularization in the covariance matrix calculation.
#'
#' @return A list containing:
#'   \itemize{
#'     \item \code{numit} An integer representing the number of iterations performed.
#'     \item \code{out} The updated list of items with updated neighborhoods and additional information.
#'     \item \code{obj_value} A numeric vector of objective values at each iteration, including the initial value.
#'   }
#'
#' @details The function updates the neighborhoods of each item based on Mahalanobis distances, recalculates means and covariances,
#' and checks for convergence. If the neighborhoods do not change between iterations, the optimization stops early.
#'
#' @keywords internal
cstep <- function(init, maxcsteps, which_indices, lambda, weights, mT) {
    .Call('_ssMRCD_cstep', PACKAGE = 'ssMRCD', init, maxcsteps, which_indices, lambda, weights, mT)
}

