% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superbData.R
\name{superbData}
\alias{superbData}
\title{Obtain summary statistics with correct error bars.}
\usage{
superbData(
  data,
  BSFactors = NULL,
  WSFactors = NULL,
  WSDesign = "fullfactorial",
  factorOrder = NULL,
  variables,
  statistic = "mean",
  errorbar = "CI",
  gamma = 0.95,
  adjustments = list(purpose = "single", popSize = Inf, decorrelation = "none",
    samplingDesign = "SRS"),
  preprocessfct = NULL,
  postprocessfct = NULL,
  clusterColumn = ""
)
}
\arguments{
\item{data}{Dataframe in wide format}

\item{BSFactors}{The name of the columns containing the between-subject factor(s)}

\item{WSFactors}{The name of the within-subject factor(s)}

\item{WSDesign}{the within-subject design if not a full factorial design (default "fullfactorial")}

\item{factorOrder}{Order of factors as shown in the graph (x axis, groups, horizontal
panels, vertical panels)}

\item{variables}{The dependent variable(s)}

\item{statistic}{The summary statistic function to use}

\item{errorbar}{The function that computes the error bar. Should be "CI" or "SE" or
any function name. Defaults to "CI"}

\item{gamma}{The coverage factor; necessary when errorbar == "CI". Default is 0.95.}

\item{adjustments}{List of adjustments as described below.
Default is \code{adjustments = list(purpose = "single", popSize = Inf, decorrelation = "none", samplingDesign = "SRS")}}

\item{preprocessfct}{is a transform (or vector of) to be performed first on data matrix of each group}

\item{postprocessfct}{is a transform (or vector of)}

\item{clusterColumn}{used in conjunction with samplingDesign = "CRS", indicates which column contains the cluster membership}
}
\value{
a list with (1) the summary statistics in summaryStatistics
(2) the raw data in long format in rawData (using numeric levels for
repeated-measure variables).
}
\description{
The function \code{suberbData()} computes standard error or confidence interval for various descriptive
statistics under various designs, sampling schemes, population size and purposes,
according to the \code{suberb} framework. See \insertCite{cgh21}{superb} for more.
}
\details{
The possible adjustements are the following
\itemize{
\item popsize: Size of the population under study. Defaults to Inf
\item purpose: The purpose of the comparisons. Defaults to "single".
Can be "single", "difference", or "tryon".
\item decorrelation: Decorrelation method for repeated measure designs.
Chooses among the methods "CM", "LM", "CA" or "none". Defaults to "none".
\item samplingDesign: Sampling method to obtain the sample. implemented
sampling is "SRS" (Simple Randomize Sampling) and "CRS" (Cluster-Randomized Sampling).
}
}
\examples{
# Basic example using a built-in dataframe as data; 
# by default, the mean is computed and the error bar are 95\% confidence intervals
# (it also produces a $rawData dataframe, not shown here)
res <- superbData(ToothGrowth, BSFactors = c("dose", "supp"), 
  variables = "len") 
res$summaryStatistics

# Example introducing adjustments for pairwise comparisons 
# and assuming that the whole population is limited to 200 persons
res <- superbData(ToothGrowth, BSFactors = c("dose", "supp"), 
  variables = "len",  
  statistic = "median", errorbar = "CI", gamma = .80,
  adjustments = list( purpose = "difference", popSize = 200) )
res$summaryStatistics

# Note that you can achieve the same with formulas
superb( len ~ dose + supp, ToothGrowth, showPlot=FALSE)

}
\references{
\insertAllCited{}
}
