% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cfg.R
\name{Stratified_cfg}
\alias{Stratified_cfg}
\title{Configuration for a Stratification Estimator}
\description{
\code{Stratified_cfg} is a configuration class for stratifying a covariate
and calculating statistics within each cell.
}
\examples{

## ------------------------------------------------
## Method `Stratified_cfg$new`
## ------------------------------------------------

Stratified_cfg$new(covariate = "test_covariate")
}
\section{Super class}{
\code{\link[tidyhte:Model_cfg]{tidyhte::Model_cfg}} -> \code{Stratified_cfg}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model_class}}{The class of the model, required for all classes
which inherit from \code{Model_cfg}.}

\item{\code{covariate}}{The name of the column in the dataset
which corresponds to the covariate on which to stratify.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Stratified_cfg-new}{\code{Stratified_cfg$new()}}
\item \href{#method-Stratified_cfg-clone}{\code{Stratified_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stratified_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-Stratified_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Stratified_cfg} object with specified number of evaluation points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stratified_cfg$new(covariate)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{covariate}}{The name of the column in the dataset
which corresponds to the covariate on which to stratify.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Stratified_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Stratified_cfg$new(covariate = "test_covariate")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stratified_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Stratified_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stratified_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
