% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{convert_units}
\alias{convert_units}
\title{Calculate unit conversions for common compounds}
\usage{
convert_units(value, formula, startunit = "mg/L", endunit = "M")
}
\arguments{
\item{value}{Value to be converted}

\item{formula}{Chemical formula of compound. Accepts compounds in mweights for conversions between g and mol or eq}

\item{startunit}{Units of current value, currently accepts g/L; g/L CaCO3; g/L N; M; eq/L;
and the same units with "m", "u", "n" prefixes}

\item{endunit}{Desired units, currently accepts same as start units}
}
\value{
A numeric value for the converted parameter.
}
\description{
This function takes a value and converts units based on compound name.
}
\examples{
convert_units(50, "ca") # converts from mg/L to M by default
convert_units(50, "ca", "mg/L", "mg/L CaCO3")
convert_units(50, "ca", startunit = "mg/L", endunit = "eq/L")

}
