% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimal_truth.R
\name{decimal_truth}
\alias{decimal_truth}
\alias{\%d==\%}
\alias{\%d!=\%}
\alias{\%d<\%}
\alias{\%d>\%}
\alias{\%d<=\%}
\alias{\%d>=\%}
\alias{\%d{}\%}
\alias{\%d!{}\%}
\alias{is_wholenumber}
\title{Safer Decimal Number (In)Equality Testing Operators}
\usage{
x \%d==\% y

x \%d!=\% y

x \%d<\% y

x \%d>\% y

x \%d<=\% y

x \%d>=\% y

x \%d{}\% bnd

x \%d!{}\% bnd

is_wholenumber(x, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{x, y}{numeric vectors, matrices, or arrays.}

\item{bnd}{either a vector of length 2, or a matrix with 2 columns and 1 row,
or else a matrix with 2 columns where \code{nrow(bnd)==length(x)}
(or can be recycled to be \code{nrow(bnd)==length(x)}). \cr
The first element/column of \code{bnd} gives the lower bound of the closed interval; \cr
The second element/column of \code{bnd} gives the upper bound of the closed interval. \cr}

\item{tol}{a single, strictly positive number close to zero, giving the tolerance.}
}
\value{
For the \code{\%d...\%} operators: \cr
A logical vector with the same dimensions as \code{x},
indicating the result of the element by element comparison. \cr
NOTE: \code{Inf} by \code{Inf} and \code{-Inf} by \code{-Inf} comparisons with
the \code{\%d...\%} operators return \code{NA}. \cr
\cr
For \code{is_wholenumber()}: \cr
A logical vector with the same dimensions as \code{x},
indicating the result of the element by element comparison. \cr
NOTE: \code{Inf}, \code{-Inf}, \code{NaN} and \code{NA} all return \code{NA} for \code{is_wholenumber()}.
}
\description{
The \code{\%d==\%, \%d!=\% \%d<\%, \%d>\%, \%d<=\%, \%d>=\%} (in)equality operators
perform decimal (type "double") number truth testing. \cr
They are virtually equivalent to the regular (in)equality operators, \cr
\code{==, !=, <, >, <=, >=}, \cr
except for 2 aspects:
\enumerate{
\item The decimal number (in)equality operators assume that
if the absolute difference between any 2 numbers
\code{x} and \code{y}
is smaller than the Machine tolerance,
\code{sqrt(.Machine$double.eps)},
then \code{x} and \code{y}
should be consider to be equal. \cr
For example: \code{(0.1 * 7) == 0.7} returns \code{FALSE}, even though they are equal,
due to the way decimal numbers are stored in programming languages like 'R' and  'Python'. \cr
But \code{(0.1 * 7) \%d==\% 0.7} returns \code{TRUE}. \cr
\item Only numeric input is allowed, so characters are not coerced to numbers. \cr
I.e. \code{1 < "a"} gives \code{TRUE}, whereas \code{1 \%d<\% "a"} gives an error. \cr
For character equality testing, see \link[stringi]{\%s==\%} from the 'stringi' package. \cr
}

Thus these operators provide safer decimal number (in)equality tests. \cr
\cr
There are also the \code{x \%d{}\% bnd} and \code{x \%d!{}\% bnd} operators,
where \code{bnd} is a vector of length 2,
or a 2-column matrix (\code{nrow(bnd)==length(x)} or \code{nrow(bnd)==1}). \cr
The \code{x \%d{}\% bnd} operator checks if \code{x}
is within the closed interval with bounds defined by \code{bnd}. \cr
The \code{x \%d!{}\% bnd} operator checks if \code{x}
is outside the closed interval with bounds defined by \code{bnd}. \cr
\cr
Moreover, the function \code{is_wholenumber()} is added, to safely test for whole numbers.
}
\examples{

x <- c(0.3, 0.6, 0.7)
y <- c(0.1 * 3, 0.1 * 6, 0.1 * 7)
print(x)
print(y)

x == y # gives FALSE, but should be TRUE
x != y # gives TRUE, should be FALSE
x > y # not wrong
x < y # gives TRUE, should be FALSE

# same as above, but here the results are correct:
x \%d==\% y # correct
x \%d!=\% y # correct
x \%d<\% y # correct
x \%d>\% y # correct
x \%d<=\% y # correct
x \%d>=\% y # correct

# check if numbers are in closed interval:
x <- c(0.3, 0.6, 0.7)
bnd <- cbind(x - 0.1, x + 0.1)
x \%d{}\% bnd
x \%d!{}\% bnd

# These operators work for integers also:
x <- 1L:5L
y <- 1L:5L
x \%d==\% y
x \%d!=\% y
x \%d<\% y
x \%d>\% y
x \%d<=\% y
x \%d>=\% y

x <- 1L:5L
y <- x + 1L
x \%d==\% y
x \%d!=\% y
x \%d<\% y
x \%d>\% y
x \%d<=\% y
x \%d>=\% y

x <- 1L:5L
y <- x - 1L
x \%d==\% y
x \%d!=\% y
x \%d<\% y
x \%d>\% y
x \%d<=\% y
x \%d>=\% y

# is_wholenumber:
is_wholenumber(1:10 + c(0, 0.1))
}
\seealso{
\link{tinycodet_safer}
}
