% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{initialize,tinytable-method}
\alias{initialize,tinytable-method}
\title{Method for a tinytable S4 object}
\usage{
\S4method{initialize}{tinytable}(
  .Object,
  data = data.frame(),
  table_input = data.frame(),
  caption = NULL,
  notes = NULL,
  theme = list("default"),
  placement = NULL,
  width = NULL
)
}
\arguments{
\item{caption}{A string that will be used as the caption of the table. This argument should \emph{not} be used in Quarto or Rmarkdown documents. In that context, please use the appropriate chunk options.}

\item{notes}{Notes to append to the bottom of the table. This argument accepts several different inputs:
\itemize{
\item Single string insert a single note: \code{"blah blah"}
\item Multiple strings insert multiple notes sequentially: \code{list("Hello world", "Foo bar")}
\item A named list inserts a list with the name as superscript: \code{list("a" = list("Hello World"))}
\item A named list with positions inserts markers as superscripts inside table cells: \code{list("a" = list(i = 0:1, j = 2, text = "Hello World"))}
}}

\item{theme}{Function or string.
\itemize{
\item String: bootstrap, grid, multipage, placement, revealjs, resize, rotate, spacing, striped, tabular, void
\item Function: Applied to the \code{tinytable} object.
}}

\item{width}{Table or column width.
\itemize{
\item Single numeric value smaller than or equal to 1 determines the full table width, in proportion of line width.
\item Numeric vector of length equal to the number of columns in \code{x} determines the width of each column, in proportion of line width. If the sum of \code{width} exceeds 1, each element is divided by \code{sum(width)}. This makes the table full-width with relative column sizes.
}}
}
\description{
Method for a tinytable S4 object
}
\keyword{internal}
