% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_components.R
\name{tm_credits}
\alias{tm_credits}
\title{Map component: (credits) text}
\usage{
tm_credits(
  text,
  size,
  color,
  padding,
  fontface,
  fontfamily,
  alpha,
  stack,
  just,
  frame,
  frame.lwd,
  frame.r,
  bg,
  bg.color,
  bg.alpha,
  position,
  group_id,
  width,
  height,
  z,
  ...
)
}
\arguments{
\item{text}{text}

\item{size}{font size}

\item{color}{font color}

\item{padding}{padding}

\item{fontface}{font face, bold, italic}

\item{fontfamily}{font family}

\item{alpha}{alpha transparency of the text}

\item{stack}{stack with other map components, either \code{"vertical"} or \code{"horizontal"}.}

\item{just}{just}

\item{frame}{frame should a frame be drawn?}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{bg}{Show background?}

\item{bg.color}{Background color}

\item{bg.alpha}{Background transparency}

\item{position}{The position specification of the component: an object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}. In case multiple components should be combined (stacked), use \code{group_id} and specify \code{component} in \code{\link[=tm_comp_group]{tm_comp_group()}}.}

\item{group_id}{Component group id name. All components (e.g. legends, titles, etc) with the same \code{group_id} will be grouped. The specifications of how they are placed (e.g. stacking, margins etc.) are determined in \code{\link[=tm_comp_group]{tm_comp_group()}} where its argument \code{id} should correspond to \code{group_id}.}

\item{width, height}{width and height of the component.}

\item{z}{z index, e.g. the place of the component relative to the other componets}

\item{...}{to catch deprecated arguments}
}
\description{
Map component that adds a text, typically used as credits. This function is the same as \code{\link[=tm_title]{tm_title()}} but with different default values.
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_components}{Vignette about components}
}
