% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_aggregations.R
\name{get_agg_inf_func}
\alias{get_agg_inf_func}
\title{Get an influence function for particular aggregate parameters}
\usage{
get_agg_inf_func(att, inf_func, whichones, weights_agg, wif = NULL)
}
\arguments{
\item{att}{vector of group-time average treatment effects}

\item{inf_func}{influence function for all group-time average treatment effects
(matrix)}

\item{whichones}{which elements of att will be used to compute the aggregated
treatment effect parameter}

\item{weights_agg}{the weights to apply to each element of att(whichones);
should have the same dimension as att(whichones)}

\item{wif}{extra influence function term coming from estimating the weights;
should be n x k matrix where k is dimension of whichones}
}
\value{
nx1 influence function
}
\description{
Get an influence function for particular aggregate parameters

This is a generic internal function for combining influence
functions across ATT(g,t)'s to return an influence function for
various aggregated treatment effect parameters.
}
\keyword{internal}
