% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_guidecats.R
\name{list_guidecats}
\alias{list_guidecats}
\title{Get list of categories that can be associated with YouTube channels}
\usage{
list_guidecats(filter = NULL, hl = NULL, ...)
}
\arguments{
\item{filter}{string; Required.
named vector of length 1
potential names of the entry in the vector:
\code{region_code}: Character. Required. Has to be a ISO 3166-1 alpha-2 code
 (see \url{https://www.iso.org/obp/ui/#search})
\code{category_id}: YouTube channel category ID}

\item{hl}{Language used for text values. Optional. Default is \code{en-US}.
For other allowed language codes, see \code{\link{list_langs}}.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
data.frame with 5 columns: \code{region_code, channelId, title,
etag, id}
}
\description{
Get list of categories that can be associated with YouTube channels
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

list_guidecats(c(region_code = "JP"))
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/guideCategories/list}
}
