% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxCLPM.R
\name{umxCLPM}
\alias{umxCLPM}
\title{Runs cross-lagged panel models}
\usage{
umxCLPM(
  waves,
  name = NULL,
  model = c("Hamaker2015", "Heise1969", "STARTS1995", "IV_RI_CLPM"),
  data = NULL,
  counts = NULL,
  summary = !umx_set_silent(silent = TRUE),
  autoRun = getOption("umx_auto_run"),
  tryHard = c("no", "yes", "ordinal", "search"),
  verbose = FALSE,
  batteries = c("scale", "ordinaloptim"),
  std = FALSE,
  ivs = NULL,
  defn = NULL,
  defto = NULL,
  type = c("Auto", "FIML", "cov", "cor", "WLS", "DWLS", "ULS"),
  allContinuousMethod = c("cumulants", "marginals")
)
}
\arguments{
\item{waves}{Number of waves of data.}

\item{name}{The name of the model (defaults to "Heise1969", "Hamaker2015", "STARTS1995" or "IV_RI_CLPM").}

\item{model}{Model type ("Hamaker2015", "Heise1969", "STARTS1995", or "IV_RI_CLPM").}

\item{data}{Data frame for the analysis.}

\item{counts}{Optional vector of count data columns.}

\item{summary}{Logical indicating whether to show a summary (default: TRUE if silent is not set).}

\item{autoRun}{Logical indicating whether to run the model (default to getOption("umx_auto_run")).}

\item{tryHard}{Method for fitting the model ("no", "yes", "ordinal", "search").}

\item{verbose}{Logical to control verbose output (default: FALSE).}

\item{batteries}{A character vector of pre-processing options ("scale", "ordinaloptim", "thresholds").}

\item{std}{Logical indicating whether to standardize the output (default: FALSE).}

\item{ivs}{Optional vector of instrumental variable column names.}

\item{defn}{Optional definition variable.}

\item{defto}{Optional variable to which to define.}

\item{type}{The method for handling missing data ("Auto", "FIML", "cov", "cor", "WLS", "DWLS", "ULS").}

\item{allContinuousMethod}{Method for handling continuous data ("cumulants", "marginals").}
}
\value{
An OpenMx model object.
}
\description{
One way of assessing causal relationships is by introducing time into the analyses.
\code{umxCLPM} implements three cross-lagged panel models (CLPM) from the literature.
The first is the classic CLPM from Heise (1969), the second is the CLPM from Hamaker et al. (2015), and
the third is the CLPM from STARTS (1995).
You simply pass the number of waves and the data set along with the model you wish to run.

Sketch mode is available; if you pass column names to data, a model object is returned for manipulation later.
}
\examples{
\dontrun{

# ================
# = 1. Load Data =
# ================
data(docData)
dt <- docData[2:9]

# ============================
# = 2. Make a CLPM model     =
# ============================
hamaker <- umxCLPM(waves = 4, name = "mymodel", model = "Hamaker2015", data = dt)
}
}
\references{
Kenny, D.A., & Zautra, A. (1995). The trait-state-error model for multiwave data. \emph{Journal of Consulting and Clinical Psychology}, \strong{63}, 52–59. \doi{10.1037/0022-006X.63.1.52}
Hamaker E.L., Kuiper R.M., & Grasman R. (2015). A critique of the cross-lagged panel model. \emph{Psychological Methods}, \strong{20}, 102–116. \doi{10.1037/a0038889}
Heise D. R. (1970). Causal inference from panel data. \emph{Sociological Methodology}, 2, 3–27. \doi{10.2307/270780}
}
\concept{CLPM Functions}
