% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bergen.R
\docType{data}
\name{bergen_4}
\alias{bergen_4}
\title{Text colours of the University of Bergen, Norway}
\format{
An object of class \code{character} of length 6.
}
\source{
Colour definitions are based on \href{https://www.uib.no}{UiB}'s 
\href{https://manual.uib.no/en/brand-guide/}{brand guide} (HTML).
}
\usage{
bergen_4
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{bergen_4} provides six text colours 
of the \href{https://www.uib.no}{University of Bergen}, Norway.
}
\details{
\code{bergen_4} is based on HEX color definitions.


Text is used in one of these colours. 
Black and white can also be used where appropriate.

All web systems should comply with universal design requirements (WCAG 2.0). 
This means that readability on a page must be ensured by remaining conscious 
of contrast, text sizes and structure.
}
\examples{
bergen_4
unikn::seecol(bergen_4, col_bg = "grey90",  col_brd = "grey90", lwd_brd = 5,  
              main = "Text colours of the University of Bergen, Norway")  # view palette

}
\seealso{
\code{\link{bergen_1}} for main colours of the University of Bergen;
\code{\link{bergen_2}} for additional colours of the University of Bergen; 
\code{\link{bergen_3}} for support colours of the University of Bergen; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Norwegian university color palettes: 
\code{\link{bergen_1}},
\code{\link{bergen_2}},
\code{\link{bergen_3}},
\code{\link{oslo}}
}
\author{
\strong{unicol}, 2023-10-11.
}
\concept{Norwegian university color palettes}
\keyword{datasets}
