% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vegtable_stat.R
\name{vegtable_stat}
\alias{vegtable_stat}
\alias{vegtable_stat.vegtable}
\alias{vegtable_stat,vegtable-method}
\title{General statistics from vegtable objects}
\usage{
vegtable_stat(vegtable, ...)

\method{vegtable_stat}{vegtable}(vegtable, ...)
}
\arguments{
\item{vegtable}{An object of class \linkS4class{vegtable}.}

\item{...}{Further arguments passed among methods.}
}
\description{
This function calculates general statistics of local \strong{Turboveg}
databases as required by GIVD (Global Index of Vegetation-Plot Databases,
\url{https://www.givd.info}).

This function is based on a script delivered by GIVD for summarising
statistics required in the descriptions of databases (see meta data in the
page of the Global Index for Vegetation-Plot Databases).
}
\examples{
## Statistics for GIVD
vegtable_stat(Kenya_veg)

}
\author{
GIVD. Adapted by Miguel Alvarez \email{kamapu78@gmail.com}
}
