% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_llt_soc.R
\name{get_llt_soc}
\alias{get_llt_soc}
\title{Extract low level terms from soc classification}
\usage{
get_llt_soc(
  term_sel,
  term_level = c("soc", "hlgt", "hlt", "pt", "llt"),
  meddra,
  verbose = TRUE
)
}
\arguments{
\item{term_sel}{A named list of character vector(s). The terms to extract llts codes from. See details.}

\item{term_level}{A character string. One of "soc", "hlgt", "hlt", "pt", or "llt"}

\item{meddra}{A data.table. Built from meddra_builders functions}

\item{verbose}{Logical. Allows you to see matching reactions in the console.}
}
\value{
A named list of integers. Low-level term codes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Collect llt codes from a \code{meddra}
data.table, given another term of the MedDRA SOC Hierarchy.
}
\details{
\code{get_llt_soc()} is an \emph{ID collector} function. The function extracts low level term codes.
\code{get_llt_soc()} is \strong{case-sensitive}, and MedDRA terms always begin with a capital letter,
in their native version.
In \code{term_sel}, all terms should come from the same hierarchical level,
e.g. all preferred terms, all high level terms, etc.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

## Finding llt codes for colitis

pt_sel <- rlang::list2(
  colitis = c("Colitis",
              "Autoimmune colitis"),
  pneumonitis = c("Pneumonitis",
                  "Organising pneumonia")
  )

hlt_sel <- rlang::list2(
  colitis = c("Gastrointestinal inflammatory disorders NEC"),
  pneumonitis = c("Pulmonary thrombotic and embolic conditions")
  )

# Remember you can use more than one term to define each adverse reaction,
# but they should all be at the same hierarchical level in meddra.

# with preferred terms

get_llt_soc(
  term_sel = pt_sel,
  term_level = "pt",
  meddra = meddra_
  )

# with high level terms

get_llt_soc(
  term_sel = hlt_sel,
  term_level = "hlt",
  meddra = meddra_
  )
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=get_llt_smq]{get_llt_smq()}}
}
\keyword{data_management}
\keyword{llt}
\keyword{meddra}
\keyword{soc}
