% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingThemes.R
\name{themeDarwin}
\alias{themeDarwin}
\title{Apply Darwin styling to a ggplot}
\usage{
themeDarwin(fontsizeRef = 10)
}
\arguments{
\item{fontsizeRef}{An integer to use as reference when adjusting label
fontsize.}
}
\description{
Apply Darwin styling to a ggplot
}
\examples{
result <- mockSummarisedResult() |> dplyr::filter(variable_name == "age")

barPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  facet = c("age_group", "sex"),
  colour = "sex") +
 themeDarwin()
}
