% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vgmsfh_utils.r
\name{coef,VGMSFH-method}
\alias{coef,VGMSFH-method}
\title{Extract Coefficients from a VGMSFH Object}
\usage{
\S4method{coef}{VGMSFH}(object, var_idx = 1, type = "fixed")
}
\arguments{
\item{object}{An object of class \code{VGMSFH}.}

\item{var_idx}{Integer. The index of the variable of interest (for multivariate models). Default is \code{1}.}

\item{type}{Character. The type of coefficient to extract. Options are:
\itemize{
\item \code{"fixed"} – extract the posterior mean of fixed effect coefficients (default).
\item \code{"spatial"} – extract the posterior mean of spatial random effects.
}}
}
\value{
A numeric vector of posterior means for the selected coefficient type.
}
\description{
This method extracts posterior mean estimates of model coefficients from a \code{VGMSFH} object. It can return either fixed effect coefficients or spatial random effects.
}
\examples{
library(vmsae)
example_model <- readRDS(system.file("example", "example_model.Rds", package = "vmsae"))
coef(example_model)  # Get fixed effect coefficients
coef(example_model, type = "spatial")  # Get spatial random effects

}
