% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAmass.R
\name{AAmass}
\alias{AAmass}
\title{Molecular mass for amino-acids}
\usage{
AAmass(massTy = "mono", inPept = TRUE, inclSpecAA = FALSE)
}
\arguments{
\item{massTy}{(character) 'mono' or 'average'}

\item{inPept}{(logical) remove H20 corresponding to water loss at peptide bond formaton}

\item{inclSpecAA}{(logical) include ornithine O & selenocysteine U}
}
\value{
This function returns a vector with masses for all amino-acids (argument 'massTy' to switch from mono-isotopic to average mass)
}
\description{
Calculate molecular mass based on atomic composition
}
\examples{
massDeFormula(c("12H12O","HO"," 2H 1 Se, 6C 2N","HSeCN"," ","e"))
AAmass()
}
\seealso{
\code{\link{massDeFormula}}, \code{\link[wrMisc]{convToNum}}
}
