% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfScaleFactor.R
\name{FitnessBasedSelfAdaptiveSF}
\alias{FitnessBasedSelfAdaptiveSF}
\title{Fitness based self adaptive scale factor.}
\usage{
FitnessBasedSelfAdaptiveSF(lF)
}
\arguments{
\item{lF}{Local configuration.}
}
\value{
A scale factor.
}
\description{
The scale factor is a product of a relative fitness 
             based term times a uniform random number.
}
\details{
The parameters are:
         \enumerate{
         \item fit: fitness of gene0. 
         \item max fit: the best fitness given by lF$CBestFitness().
          }
       
         The scale factor is in the interval of \code{[-1.05, 1.05]}.

         For details, see section 4 of Sharma et al. (2019), 
         p. 931 or Sharma et al. (2013). 

         If the optimal fitness value is \code{0}, 
         the quotient for computing the relative fitness is
         \code{Inf} or \code{-Inf}. In this case,
         \code{SF=0.1}.
}
\examples{
parm<-function(x){function() {return(x)}}
lFxegaDfGene$CBestFitness<-parm(35)
pop3<-lapply(rep(0,3), function(x) xegaDfGene::xegaDfInitGene(lFxegaDfGene))
lFxegaDfGene$gene0<-pop3[[1]]
FitnessBasedSelfAdaptiveSF(lFxegaDfGene) 
lFxegaDfGene$gene0<-pop3[[2]]
FitnessBasedSelfAdaptiveSF(lFxegaDfGene) 
lFxegaDfGene$gene0<-pop3[[3]]
FitnessBasedSelfAdaptiveSF(lFxegaDfGene) 
}
\references{
Sharma, Prashant; Sharma, Harish; Kumar, Sandeep; Bansal, Jagdish Chand
(2019):
A Review on Scale Factor Strategies in Differential Evolution Algorithm.
pp. 925-934. In:
Bansal, Jagdish Chand et al. (2019)
Soft Computing for Problem Solving.
Advances in Intelligent Systems and Computing, Vol. 817.
Springer, Singapore, 2019. (ISBN:978-981-13-1594-7)

Sharma, Harish; Shrivastava, Pragati; Bansal, Jagdish Chand; 
Tiwari, Ritu (2013)
Fitness Based Self Adaptive Diﬀerential Evolution
pp. 71-94. In:
Terrazas et al. (2013) 
Nature Inspired Cooperative Strategies for Optimization (NICSO 2013)
Springer, Heidelberg.
(doi:10.1007/978-3-319-01692-4_6)
}
\seealso{
Other Scale Factor: 
\code{\link{CauchySF}()},
\code{\link{ConstScaleFactor}()},
\code{\link{DETVSF}()},
\code{\link{RandomGaussianSF}()},
\code{\link{UniformRandomScaleFactor}()},
\code{\link{UniformRandomScaleFactorDERSF}()}
}
\concept{Scale Factor}
