% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xkcdman.R
\name{xkcdman}
\alias{xkcdman}
\title{Draw a stick figure}
\usage{
xkcdman(mapping, data, ...)
}
\arguments{
\item{mapping}{Mapping between variables and aesthetics generated by \code{\link[ggplot2]{aes}}. See Details.}

\item{data}{Dataset used in this layer.}

\item{...}{Optional arguments.}
}
\value{
A layer.
}
\description{
It draws a stick figure
}
\details{
This function draws a stick figure.

The following aesthetics are required:
\enumerate{
 \item x: x position of the center of the head.
 \item y: y position of the center of the head.
 \item scale: scale of the man. It is the size of the man (in units of
 the Y axis).
 \item ratioxy: Ratio x to y of the graph (Use ratioxy <- diff(xrange) / diff(yrange))
 \item angleofspine: angle between the spine and a horizontal line
 that passes by the center of the head.
 \item anglerighthumerus, anglelefthumerus: angle between the right/left humerus and a
 horizontal line that passes by the top of the spine.
 \item anglerightradius, angleleftradius: angle between the right/left radius and a
 horizontal line that passes by the end of the right/left humerus.
 \item anglerightleg, anglelefthleg:  angle between the right/left left and a
 horizontal line that passes by the end of the end of the spine.
 \item angleofneck: angle between the begin of spine and a horizontal
 line that passes by the center of the head.
}
Angles are in radians.

Additionally, you can use the aesthetics of \code{\link[ggplot2]{geom_path}},
and \code{xkcdline}.
}
\examples{
datascaled <- data.frame(x=c(-3,3),y=c(-30,30))
p <- ggplot(data=datascaled, aes(x=x,y=y)) + geom_point()
xrange <- range(datascaled$x)
yrange <- range(datascaled$y)
ratioxy <- diff(xrange) / diff(yrange)
 
mapping <- aes(x=x,
               y=y,
               scale=scale,
               ratioxy=ratioxy,
               angleofspine = angleofspine,
               anglerighthumerus = anglerighthumerus,
               anglelefthumerus = anglelefthumerus,
               anglerightradius = anglerightradius,
               angleleftradius = angleleftradius,
               anglerightleg =  anglerightleg,
               angleleftleg = angleleftleg,
               angleofneck = angleofneck,
               color = color )
 
dataman <- data.frame( x= c(-1,0,1), y=c(-10,0,10),
                  scale = c(10,7,5),
                  ratioxy = ratioxy,
                  angleofspine =  seq(- pi / 2, -pi/2 + pi/8, l=3) ,
                  anglerighthumerus = -pi/6,
                  anglelefthumerus = pi + pi/6,
                  anglerightradius = 0,
                  angleleftradius = runif(3,- pi/4, pi/4),
                  angleleftleg = 3*pi/2  + pi / 12 ,
                  anglerightleg = 3*pi/2  - pi / 12,
                  angleofneck = runif(3, min = 3 * pi / 2 - pi/10 , max = 3 * pi / 2 + pi/10),
                  color=c("A","B","C"))
 
p + xkcdman(mapping,dataman)
}
\seealso{
\code{\link[ggplot2]{aes}},  \code{\link[ggplot2]{geom_path}},  \code{\link{xkcdline}}
}
\keyword{manip}
