% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{unnest.list}
\alias{unnest.list}
\title{Collapse Uninformative Levels of a List}
\usage{
\method{unnest}{list}(x, ...)
}
\arguments{
\item{x}{list}
}
\value{
list
}
\description{
The list method for unnest() recursively
ascends a nested list, removing uninformative levels.
}
\examples{

a <- 'ITEM: [ label: sunshine, [foo: 1, bar: 3]]'

#  yaml.load() sees label nested one-deep, and foo nested two-deep:
yaml::yaml.load(a)

# unnest() sees label nested zero-deep, and foo nested one-deep:
unnest(yaml::yaml.load(a))

# as_yamlet() provides explicit name (default key) for second element of ITEM:
as_yamlet(a)
}
\seealso{
Other unnest: 
\code{\link{unnest}()},
\code{\link{unnest.default}()}
}
\concept{unnest}
\keyword{internal}
