% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.4way.R
\name{lm_plot.4way}
\alias{lm_plot.4way}
\title{Create a Four-Panel Regression Assumptions Plot}
\usage{
lm_plot.4way(
  mdl,
  ...,
  is.ts = FALSE,
  pred.intvl = TRUE,
  pval.SW = FALSE,
  pval.BP = FALSE,
  pval.DW = FALSE,
  cook.loess = FALSE,
  rtn.all = FALSE,
  plt.nms = c("fit", "var", "qq", ifelse(is.ts, "ac", "infl")),
  parms = list()
)
}
\arguments{
\item{mdl}{A fitted model object (typically from \code{\link[stats]{lm}}).}

\item{...}{Additional arguments (not currently used).}

\item{is.ts}{Logical; \code{TRUE} if data are time series, \code{FALSE} otherwise.}

\item{pred.intvl}{Logical; plot prediction interval on fitted vs observed.}

\item{pval.SW}{Logical; include Shapiro–Wilk p-value in \code{qq}  plot.}

\item{pval.BP}{Logical; include Breusch–Pagan p-value in \code{var} plot.}

\item{pval.DW}{Logical; include Durbin–Watson p-value in \code{ac}  plot.}

\item{cook.loess}{Logical; overlay Cook's distance loess curve in \code{infl}  plot.}

\item{rtn.all}{Logical; return all plots and parameters (vs. 4-way plot only).}

\item{plt.nms}{Character vector of which panels to plot. Defaults to fit, var, qq, and ac/infl depending on \code{is.ts} (Order: start upper left, continue clockwise)}

\item{parms}{List of overrides to plot formatting parameters (see \code{\link{lm_plot.parms}}).}
}
\value{
A \code{ggplot} object representing the 4-way diagnostic panel.
  Optionally invisibly returns a list containing:
  \itemize{
    \item \code{p_4way} – the combined plot,
    \item other elements passed through from the individual plot functions.
  }
}
\description{
Generates a 4-panel diagnostic plot for a multiple regression model, including:
1) Fitted values vs. observed values (check for non-linearity),
2) Quantile–Quantile plot of residuals (check for non-normality),
3) Residuals vs. fitted values (check for heteroskedasticity),
4) Autocorrelation for time series otherwise influence plot (leverage also available).
}
\details{
This function is a high-level wrapper that calls internal plotting functions
(\code{lm_plot.fit}, \code{lm_plot.var}, \code{lm_plot.qq}, and either \code{lm_plot.ac} or
\code{lm_plot.infl}) and assembles their outputs into a combined \code{\link[cowplot]{plot_grid}}.
}
\examples{

fit <- lm(mpg ~ wt + hp, data = mtcars)
lm_plot.4way(fit, is.ts = FALSE, pval.SW = TRUE)
fit <- lm(Employed ~ ., data = longley)
lm_plot.4way(fit, is.ts = TRUE, pval.DW = TRUE)

}
