% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.fit.R
\name{lm_plot.fit}
\alias{lm_plot.fit}
\title{Plot Observed vs. Fitted Values to Check Linearity}
\usage{
lm_plot.fit(
  mdl,
  ...,
  pred.intvl = TRUE,
  parms = lm_plot.parms(mdl),
  df = lm_plot.df(mdl, parms = parms)
)
}
\arguments{
\item{mdl}{A fitted model object (typically from \code{\link[stats]{lm}}).}

\item{...}{Additional arguments (not currently used).}

\item{pred.intvl}{(logical, default = TRUE) Option to show prediction interval bounds of fitted values.}

\item{parms}{List of plotting parameters, usually from \code{lm_plot.parms()}.}

\item{df}{Data frame with augmented model data. Defaults to \code{lm_plot.df(mdl)}.}
}
\value{
A \code{ggplot} object representing the fitted vs. observed plot. Included as an attribute \code{"parm"} is a list containing:
\itemize{
  \item \code{lim} Plotted limits on \code{x} and \code{y} axes,
  \item \code{pred.intvl} Option to show prediction interval,
}
}
\description{
Generates a scatter plot of fitted values versus observed values from a linear model, with identification of outlier points and optional prediction interval. The plot includes a reference line \code{y = x} for assessing linearity.
}
\details{
The plot visualizes fitted versus observed values, includes a diagonal reference line, marks outliers, and can optionally display prediction intervals. Outlier and regular points can be labeled. This plot is useful for visually assessing linearity and model fit quality.
}
\examples{
mdl <- lm(Sepal.Length ~ Sepal.Width, data = iris)
lm_plot.fit(mdl)

}
\seealso{
\code{\link{lm_plot.df}}, \code{\link{lm_plot.parms}}
}
