% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.qq.R
\name{lm_plot.qq}
\alias{lm_plot.qq}
\title{Q-Q Plot of Residuals to Assess Normality}
\usage{
lm_plot.qq(
  mdl,
  ...,
  pval.SW = FALSE,
  parms = lm_plot.parms(mdl),
  df = lm_plot.df(mdl, parms = parms)
)
}
\arguments{
\item{mdl}{A fitted model object (typically from \code{\link[stats]{lm}}).}

\item{...}{Additional arguments (not currently used).}

\item{pval.SW}{(logical, default = FALSE) indicates whether to include Shapiro-Wilk p-value on the plot.}

\item{parms}{List of plotting parameters, usually from \code{lm_plot.parms()}.}

\item{df}{Data frame with augmented model data. Defaults to \code{lm_plot.df(mdl)}.}
}
\value{
A \code{ggplot} object representing the quantile-quantile plot. Included as an attribute \code{"parm"} is a list containing:
\itemize{
  \item \code{lim} Plotted limits on \code{x} and \code{y} axes,
  \item \code{pval.SW} Option to show Shapiro-Wilk p-value,
  \item \code{DW} The \code{htest} object with Shapiro-Wilk test results.
}
}
\description{
Produces a Q-Q plot of residuals from a linear model to test for normality, optionally annotating outlier points and adding the Shapiro-Wilk test p-value.
}
\details{
The plot visualizes the distribution of residuals against theoretical normal quantiles. Points are colored and shaped by outlier status, and a reference Q-Q line is added. Optionally, outlier and regular points can be labeled. If enabled, the Shapiro-Wilk normality test p-value is displayed.
}
\examples{
mdl <- lm(Sepal.Length ~ Sepal.Width, data = iris)
lm_plot.qq(mdl)

}
\seealso{
\code{\link{lm_plot.df}}, \code{\link{lm_plot.parms}}, \code{\link[stats]{shapiro.test}}
}
