% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumry.R
\name{sumry}
\alias{sumry}
\title{Summary Descriptive Statistics for BAQM}
\usage{
sumry(x, ...)
}
\arguments{
\item{x}{An object to summarize; methods are available for data frames, lists, vectors, linear regression models (\code{lm}), and best subsets models (\code{regsubsets} from the \code{leaps} package).}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Invisibly returns a list of summary tables for each variable.
}
\description{
\code{sumry} is a generic function for the \code{BAQM} package used to produce summaries of the results of certain model fitting functions.
}
\examples{
sumry(penguins)
sumry(data.frame(a = rnorm(100),
          b = c(NA, 1:98, NA),
          c = sample(letters[4:6], 100, TRUE)),
          transpose = TRUE, pad = 1)
sumry(lm(Sepal.Length ~ ., data = iris))
sumry(leaps::regsubsets(mpg ~ ., data = mtcars, nbest = 2))

}
