% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_sigma2.CI.R
\name{ggplot_sigma2.CI}
\alias{ggplot_sigma2.CI}
\title{A credible interval plot of posterior of sigma squared}
\usage{
ggplot_sigma2.CI(
  Gibbs,
  burnin = NA,
  permutation = NA,
  main.bool = TRUE,
  main.title = NULL,
  x.label = "Variables",
  y.label = "Variance",
  var_labels = NULL
)
}
\arguments{
\item{Gibbs}{Gibbs sample from \code{BCFM} function}

\item{burnin}{Number of burn-in period. If not specified, it uses the first tenths sample as burn-in period.}

\item{permutation}{Permutation vector, if applicable}

\item{main.bool}{Return main title. Default is TRUE.}

\item{main.title}{Main title for the plot. Default is expression for sigma squared.}

\item{x.label}{X-axis label. Default is "Variables"}

\item{y.label}{Y-axis label. Default is "Variance"}

\item{var_labels}{Character vector of variable names. If NULL, defaults to Variable 1, Variable 2, etc.}
}
\value{
A ggplot object showing the 95\\% credible intervals (error bars) and
posterior means (points) of the idiosyncratic variances sigma squared for
each variable.
}
\description{
It returns a credible interval plot of idiosyncratic variance, sigma squared. The lines are 95\% intervals, while the circles are posterior mean.
}
