% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_methods.R
\name{summary.BCSreg}
\alias{summary.BCSreg}
\alias{print.summary.BCSreg}
\title{Summarizing a Box-Cox Symmetric Regression Fit}
\usage{
\method{summary}{BCSreg}(object, ...)

\method{print}{summary.BCSreg}(x, digits = getOption("digits"), ...)
}
\arguments{
\item{object}{an object of class \code{"BCSreg"}, a result of a call to \link{BCSreg}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.BCSreg"}, a result of a call to \link{summary.BCSreg}.}

\item{digits}{a non-null value for digits specifies the minimum number of significant digits to
be printed in values.}
}
\value{
The function \code{summary.BCSreg} returns an object of class \code{"summary.BCSreg"},
    which consists of a list with the following components:
 \describe{
    \item{call}{the original function call, given in \code{object}.}
    \item{mu}{summary statistics for the scale submodel.}
    \item{sigma}{summary statistics for the relative dispersion submodel.}
    \item{lambda}{summary statistics for the skewness parameter. If this parameter is not
        statistically different from zero, the fitted Box-Cox symmetric (BCS) distribution
        can be reduced to a more parsimonious log-symmetric distribution.}
    \item{alpha}{summary statistics for the zero-adjustment submodel when a zero-adjusted
        model is considered; and \code{NULL}, otherwise.}
    \item{zeta}{the specified value for the extra parameter of the fitted
        BCS distribution, if applicable.}
    \item{family}{the generating family of the fitted BCS distribution.}
    \item{link}{a list with elements \code{"mu"} and \code{"sigma"} with the
        specified link functions for the \code{mu} and \code{sigma} regression
        structures, respectively. If the model is zero-adjusted, the element
        \code{"alpha"} will also be returned with the link function for
        the regression structure of the zero-adjustment parameter.}
    \item{converged}{logical indicating successful convergence of the iterative
        process.}
    \item{iterations}{number of iterations reached until the optimization algorithm converges.}
    \item{logLik}{log-likelihood of the fitted model.}
    \item{df}{number of model parameters}
    \item{residuals}{a vector of quantile residuals.}
    \item{pseudo.r.squared}{pseudo R-squared value.}
    \item{Upsilon.zeta}{an overall goodness-of-fit measure.}
    \item{v}{a vector with the \eqn{v(z)} values for all the observations.}
    \item{AIC, BIC}{Akaike and Bayesian information criteria.}
 }
}
\description{
\code{summary} method for class \code{"BCSreg"}.
}
\details{
An object of class \code{"summary.BCSreg"} provides additional information from a Box-Cox
    symmetric or zero-adjusted Box-Cox symmetric regression fit. In addition to summary
    tables with estimates, standard errors, and individual significance tests of the
    regression coefficients, it also provides the quantile residuals (Dunn and Smyth, 1996)
    and goodness-of-fit measures.

The goodness-of-fit measures include:

  \itemize{
    \item{A pseudo-\eqn{R_p^2} defined based on Ferrari and Cribari-Neto (2004) as the
        square of the sample correlation coefficient between \eqn{d_1(y)} and
        \eqn{d_1(\widehat{y})}, where \eqn{y} is the response variable,
        \eqn{\widehat{y}} is the adjusted median, and \eqn{d_1()} is the link
        function (\code{link}) used in the regression structure for the scale parameter.
        By definition, \eqn{0 \leq R_p^2 \leq 1}, and perfect agreement between the fitted
        values and the response yields \eqn{R_p^2 = 1}.}

    \item{A general goodness-of-fit measure based on Vanegas and Paula (2016), defined as

      \deqn{
        \Upsilon_\zeta = \frac{1}{n} \sum_{i=1}^n \left| \Phi^{-1}[\widehat{F}(y_{(i)})] - \nu_{(i)} \right|,
      }

      where \eqn{y_{(i)}} is the \eqn{i}th order statistic of the response, \eqn{\nu_{(i)}}
      is the expected value of the \eqn{i}th order statistic from a standard normal sample
      of size \eqn{n}, \eqn{\Phi(\cdot)} denotes the cumulative distribution function
      of the standard normal distribution, and \eqn{\widehat{F}(\cdot)} denotes the fitted cumulative
      distribution function of the assumed distribution for the response.}

    \item{A weighting function \eqn{v(\cdot)} that plays a role in the parameter estimation
        process, providing information about the individual contribution of each
        observation. It depends on the generating density function and is constant for
        distributions generated by the normal family (\code{family = "NO"}).}
  }
}
\examples{
# BCS regression for strictly positive response variables

## Data set: raycatch (for description, run ?raycatch)
hist(raycatch$cpue, xlab = "Catch per unit effort")
plot(cpue ~ tide_phase, raycatch, pch = 16,
     xlab = "Tide phase", ylab = "Catch per unit effort")
plot(cpue ~ location, raycatch, pch = 16,
     xlab = "Location", ylab = "Catch per unit effort")
plot(cpue ~ max_temp, raycatch, pch = 16,
     xlab = "Maximum temperature", ylab = "Catch per unit effort")

## Fit examples

### Fit a single Box-Cox normal regression model:
fit_bcno1 <- BCSreg(cpue ~ location + tide_phase + max_temp, raycatch)
summary(fit_bcno1)

# Other quantities can be obtained from a summary.BCSreg object:
aux <- summary(fit_bcno1)
class(aux)
str(aux)

### Fit a double Box-Cox normal regression model:
fit_bcno2 <- BCSreg(cpue ~ location + tide_phase |
                      location + tide_phase + max_temp, raycatch)
summary(fit_bcno2)


### Fit a double Box-Cox power exponential regression model (family = "PE"):
fit_bcpe <- BCSreg(cpue ~ location + tide_phase + max_temp |
                     location + tide_phase + max_temp, raycatch, family = "PE", zeta = 4)
summary(fit_bcpe)

### Fit a double log-power exponential regression model (lambda = 0):
fit_lpe <- BCSreg(cpue ~ location + tide_phase + max_temp |
                    location + tide_phase + max_temp, raycatch, family = "PE",
                  zeta = 4, lambda = 0)
summary(fit_lpe)

# Zero-adjusted BCS (ZABCS) regression for nonnegative response variables

## Data set: renewables2015 (for description, run ?renewables2015)
plot(ecdf(renewables2015$renew_elec_output), cex = 0.3, main = "Empirical CDF")
abline(h = mean(renewables2015$renew_elec_output == 0), col = "grey", lty = 3)
text(1250, 0.155, paste0("prop. of zeros: ~0.12"), col = "blue")

plot(renew_elec_output ~ adj_sav_edu, renewables2015, pch = 16,
     xlab = "Education expenditure (percent of GNI)",
     ylab = "Renewable electricity output (in TWh)")
plot(renew_elec_output ~ agri_land, renewables2015, pch = 16,
     xlab = "Matural logarithm of total agricultural land area",
     ylab = "Renewable electricity output (in TWh)")

## Fit examples

### Fit a single zero-adjusted Box-Cox normal regression model:
fit_zabcno1 <- BCSreg(renew_elec_output ~ adj_sav_edu + agri_land, renewables2015)
summary(fit_zabcno1)

# Other quantities obtained from a zero-adjusted fit:
aux <- summary(fit_zabcno1)
str(aux)

### Fit a double zero-adjusted Box-Cox normal regression model:
fit_zabcno2 <- BCSreg(renew_elec_output ~ adj_sav_edu + agri_land |
                        adj_sav_edu + agri_land, renewables2015)
summary(fit_zabcno2)

### Fit a triple zero-adjusted Box-Cox normal regression model:
fit_zabcno3 <- BCSreg(renew_elec_output ~ adj_sav_edu + agri_land |
                        adj_sav_edu + agri_land |
                        adj_sav_edu + agri_land, renewables2015)
summary(fit_zabcno3)


### Fit a triple zero-adjusted Box-Cox power exponential regression model (family = "PE"):
fit_zabcpe <- BCSreg(renew_elec_output ~ adj_sav_edu + agri_land |
                       adj_sav_edu + agri_land |
                       adj_sav_edu + agri_land, renewables2015, family = "PE", zeta = 4)
summary(fit_zabcpe)

### Fit a triple zero-adjusted log-power exponential regression model (lambda = 0):
fit_zalpe <- BCSreg(renew_elec_output ~ adj_sav_edu + agri_land |
                      adj_sav_edu + agri_land |
                      adj_sav_edu + agri_land, renewables2015, family = "PE",
                    zeta = 4, lambda = 0)
summary(fit_zalpe)
summary(fit_lpe)
}
\references{
Dunn, P. K. and Smyth, G. K. (1996). Randomized quantile residuals.
    \emph{Journal of Computational and Graphical Statistics}, \bold{5}, 236---244.

    Ferrari, S., and Cribari-Neto, F. (2004). Beta regression for modelling
    rates and proportions. \emph{Journal of Applied Statistics}, \bold{31}, 799---815.

    Medeiros, R. M. R., and Queiroz, F. F. (2025). Flexible modeling of nonnegative continuous
    data: Box-Cox symmetric regression and its zero-adjusted extension.

    Vanegas, L. H., and Paula, G. A. (2016). Log-symmetric distributions:
    statistical properties and parameter estimation. \emph{Brazilian Journal of
    Probability and Statistics}, \bold{30},196---220
}
\author{
Francisco F. de Queiroz <\email{felipeq@ime.usp.br}>

Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
