% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\name{arguments.link}
\alias{arguments.link}
\title{Shared documentation for link functions}
\arguments{
\item{error.scale}{either 0 or 1; the scale for the error term. Default is
\code{error.scale = 1} (predictive scale).}

\item{linkg}{link functions. Can be specified as a character, two-character
vector or a named list. The corresponding text strings for currently
available links are listed in \link{link.btsr}. Default values depend on the
model. For some models default values override user specifications. See
the Section \link[=arguments.link]{Link defaults} for details.}

\item{linkh}{a character indicating which link must be associated to the
chaotic process.  See the Section \sQuote{The BTSR structure} in
\link{btsr-package} for details and \link{link.btsr} for valid links. Default is
\code{linkh = "linear"}.}

\item{configs.linkg}{a list with two elements, \code{ctt} and \code{power}, which
define the constant \eqn{a} and the exponent \eqn{b} in the link function
\eqn{g(x) = a x^b}. Each element can be specified as a numeric value, a
vector of size 2 or a named list. The default is \code{configs.linkg = NULL}.
See the Section \link[=arguments.link]{Link defaults}  for details.}

\item{configs.linkh}{a list with extra configurations for the link \eqn{h}.
For now, only used if \code{linkh = "linear"} or \code{"polynomial"}. Default is
\code{configs.linkh = list(ctt = 1, power = 1)}.}
}
\description{
This is the common documentation for arguments related link functions in BTSR
models.
}
\section{Link defaults}{
\code{linkh} and \code{configs.linkh} only apply to BARC models.\cr

\code{linkg} can be specified in one of two ways
\itemize{
\item \strong{Legacy structure:} a character or two-character vector. If
only one string is provided, the same link name is used for \code{g11} and \code{g12}.
Internally, this structure is automatically converted to the new format with
\code{g2 = g21 = g22 = g23 = "linear"}.

\item \strong{New structure:} a named list with optional elements (order is
irrelevant) \code{g11}, \code{g12}, \code{g2}, \code{g21}, \code{g22} and \code{g23}. These links apply,
respectively, to \eqn{\mu_t}, \eqn{Y_t} (in the AR recursion or part 1),
\eqn{\nu_t}, \eqn{\vartheta_t = g_2(\nu_t)}, \eqn{\vartheta_t} (in the AR
recursion of part 2) and \eqn{e_{1t}} (to build the error term in part 2).
}
For models that do not have the \eqn{\nu} parameter, the links \code{g2}, \code{g21},
\code{g22} and \code{g23} are set to \code{"linear"} for compatibility with Fortran
subroutines.

Missing entries in the \code{linkg} list follow these rules
\itemize{
\item If either \code{g11} or \code{g12} is missing (but not both), internally it is
set \code{g12 = g11}.

\item If both \code{g11} and \code{g12} are missing, use the default values for the
particular model (see below).

\item If \code{phi = NULL} for part 1, \code{g12} is not required, hence set to
\code{"linear"} and ignored in Fortran.

\item If \code{phi = NULL} for part 2, \code{g22} is not required, hence set to
\code{"linear"} and ignored in Fortran.

\item If either \code{g21} or \code{g22} is missing (but not both), internally it is
set \code{g22 = g21}.

\item If both \code{g21} and \code{g22} are missing, use the default values for the
particular model (see below).
}

Default \code{linkg} values are model-dependent (based on the string provided with
\code{model}):
\itemize{
\item For all models where \eqn{\nu} is constant over time:\cr
internally, \code{g2}, \code{g21}, and \code{g22} are forced to \code{"linear"}, with \eqn{a = 1}.\cr
\strong{Overrides any user specifications}.

\item iid samples:\cr
\strong{Overrides any user specifications}.\cr
\code{linkg = "linear"} (with \eqn{a = 1}). Internally converted to

\if{html}{\out{<div class="sourceCode">}}\preformatted{linkg = list(g11 = "linear", g12 = "linear", g2 = "linear"
             g21 = "linear", g22 = "linear", g23 = "linear")
}\if{html}{\out{</div>}}

\item BARFIMA, KARFIMA, ULARFIMA, UWARFIMA:\cr
\code{linkg = "logit"}. Internally converted to

\if{html}{\out{<div class="sourceCode">}}\preformatted{linkg = list(g11 = "logit", g12 = "logit", g2 = "linear"
             g21 = "linear", g22 = "linear", g23 = "linear")
}\if{html}{\out{</div>}}

\item GARFIMA:\cr
\code{linkg = "log"}. Internally converted to

\if{html}{\out{<div class="sourceCode">}}\preformatted{linkg = list(g11 = "log", g12 = "log", g2 = "linear"
             g21 = "linear", g22 = "linear", g23 = "linear")
}\if{html}{\out{</div>}}

\item MARFIMA:\cr
\code{linkg = "cloglog"}. Internally converted to

\if{html}{\out{<div class="sourceCode">}}\preformatted{linkg = list(g11 = "cloglog", g12 = "cloglog", g2 = "linear"
             g21 = "linear", g22 = "linear", g23 = "linear")
}\if{html}{\out{</div>}}

\item BARFIMAV, GARFIMAV, KARFIMAV, UWARFIMAV:

\code{g11} and \code{g12} have the same default values as the particular model where
\eqn{\nu} is constant over time.

\code{g2 = "default"}, meaning that \code{g2} is set as the the default link for
the model.
\itemize{
\item For BARFIMAV \code{"default" = SIP} with \eqn{a = b = 1}.
\item For GARFIMAV \code{"default" = SIP} with \eqn{a = 0} and \eqn{b = 1}.
\item For remaining models \code{"default" = "linear"} with \eqn{a = 1}.
}

\code{g21} depends on the model.
\itemize{
\item For BARFIMAV \code{g21 = "logit"}
\item For any other model \code{g21 = "log"}.
}

For \code{g22}, the default is to assume  \code{g22 = g21}.

Finally, \verb{g23 = "polynomial}, with \eqn{a = 1} and \eqn{b = 2} (set in
\code{configs.link})

\item Particular cases (e.g., BREG, BREGV) inherit defaults from parent
models (except iid samples).
}

\code{configs.linkg} if provided, it must be provided as a list with optional
elements, \code{ctt} and \code{power}, which define the constant \eqn{a} and the
exponent \eqn{b} in the link function \eqn{g(x) = a x^b}. Each element in
this list can be specified in one of two ways
\itemize{
\item \strong{Legacy structure:} a numeric value (applied uniformly across
all linear links) or a numeric vector of length 2, which will be associated
to \code{g11} and \code{g12}.

\item \strong{New structure:} a named list with optional elements (order is
irrelevant) \code{g11}, \code{g12}, \code{g2}, \code{g21}, \code{g22} and \code{g23}.
}
For now, the arguments \code{ctt} and \code{power} are only used when the link function
is \code{"linear"} or \code{"polynomial"}. If \code{NULL}, default is to assume that \code{ctt}
and \code{power} are both equal to 1 for all links.
}

\seealso{
\link{BTSR.model.defaults}: function to print default settings for a
specified model
}
