% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustCpObj.R
\name{plot_psm.ClustCpObj}
\alias{plot_psm.ClustCpObj}
\title{Plot the Posterior Similarity Matrix (PSM) for a ClustCpObj}
\usage{
\method{plot_psm}{ClustCpObj}(object, reorder = TRUE, title = "Posterior Similarity Matrix", ...)
}
\arguments{
\item{object}{an object of class \code{ClustCpObj}.}

\item{reorder}{Logical; if \code{TRUE} (default), items are reordered using
hierarchical clustering to highlight clusters in the final plot}

\item{title}{Character; the plot title (default: \code{"Posterior Similarity Matrix"}).}

\item{...}{parameter of the generic method.}
}
\value{
A \code{ggplot2} object representing the posterior similarity matrix.
}
\description{
This function computes and visualizes the posterior similarity matrix
(PSM) from a \code{ClustCpObj} object.
The PSM shows the posterior co-clustering probabilities of all observations.
}
\examples{
data("stock_uni")

params_uni <- list(a = 1,
                   b = 1,
                   c = 1,
                   phi = 0.1)

out <- clust_cp(data = stock_uni[1:3,], n_iterations = 1000, n_burnin = 100,
                L = 1, q = 0.5, B = 500, params = params_uni, kernel = "ts")
plot_psm(out)
}
