% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{print.BayesPET_predtime}
\alias{print.BayesPET_predtime}
\title{Print method for BayesPET prediction objects}
\usage{
\method{print}{BayesPET_predtime}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"BayesPET_predtime"} returned by
\code{\link{predict_eventtime}}.}

\item{\dots}{Additional arguments passed to methods. Not used.}
}
\value{
The object \code{x}, invisibly.
}
\description{
Displays a brief overview of an object of class \code{"BayesPET_predtime"}
and lists the components available in the result. For numerical summaries,
use \code{\link{summary}}; for visualization, use \code{\link{plot}}.
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(data_example)
## Reduced number of chains and iterations compared to defaults
## to keep the example computationally manageable.
pred <- predict_eventtime(
  N = 200,
  E_target = 150,
  data.enroll = data_example$example_enroll,
  data.eventcensor = data_example$example_eventcensor,
  blinded = TRUE,
  p_trt = 0.5,
  chains = 2,
  iter = 2000,
  assess_window = 2,
  seed.fit = 1,
  seed.pred = 2,
  return_fit = TRUE,
  return_draws = TRUE,
  quiet = TRUE
)

print(pred)
summary(pred)
plot(pred)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET prediction: \code{\link{plot.BayesPET_predtime}},
\code{\link{predict_eventtime}}, \cr
\code{\link{summary.BayesPET_predtime}}
}
