% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borrow.wt.R
\name{borrow.wt}
\alias{borrow.wt}
\title{Calculate Borrowing Weights from Historical Data}
\usage{
borrow.wt(
  Yc,
  nc,
  Ych,
  nch,
  nche,
  a0c = 0.001,
  b0c = 0.001,
  delta_threshold = 0.1,
  method = "Empirical Bayes",
  theta = 0.5,
  eta = 1
)
}
\arguments{
\item{Yc}{A scalar integer. The number of responders in the current control arm.}

\item{nc}{A scalar integer. The number of subjects in the current control arm.}

\item{Ych}{A scalar integer. The number of responders in the historical control arm.}

\item{nch}{A scalar integer. The number of subjects in the historical control arm.}

\item{nche}{A scalar. The maximum number of subjects that can be borrowed,
used to calculate the global weight \code{a}.}

\item{a0c, b0c}{Numerics. Hyperparameters for the Beta(a0c, b0c) prior on
the control response rate. Default to 0.001.}

\item{delta_threshold}{A numeric threshold. Borrowing is only triggered if the
absolute difference in observed response rates is less than this value.
Default is 0.1.}

\item{method}{A string specifying the dynamic borrowing method. Options
include "Empirical Bayes", "Bayesian p", "Generalized BC", "JSD".}

\item{theta}{A numeric scalar in (0, 1), applicable to the "Generalized BC"
method. Default is 0.5.}

\item{eta}{A numeric scalar, applicable to the "Bayesian p", "Generalized
BC", and "JSD" methods. Default is 1.}
}
\value{
A list containing three values:
\itemize{
\item a: The global borrowing weight, calculated as nche / nch.
\item wd: The dynamic borrowing weight, calculated based on the chosen method.
\item w: The final overall borrowing weight, which is a product of \code{a},
\code{wd}, and an indicator for whether the response rates are sufficiently similar.
}
}
\description{
Calculates borrowing weights for a hybrid control arm using one of several
dynamic borrowing methods.
}
\details{
The function implements the following methods:
\itemize{
\item{"Empirical Bayes"}: The weight is determined by maximizing the
marginal likelihood of the current data.
\item{"Bayesian p"}: Similarity is measured by a Bayesian p-value
comparing the posterior distributions.
\item{"Generalized BC"}: Uses the Generalized Bhattacharyya Coefficient.
The standard BC is a special case with theta = 0.5.
\item{"JSD"}: Uses the Jensen-Shannon Divergence to measure similarity.
}
}
\examples{
\donttest{
borrow.wt(Yc=12, nc=40, Ych=54, nch=180, nche=40, a0c=0.001,
b0c=0.001, delta_threshold=0.1, eta=1)
}

}
