% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_fit.R
\name{bayesian_computations}
\alias{bayesian_computations}
\alias{credint}
\alias{bayesian_scoring}
\alias{bayesian_prevalence_estimate}
\title{Bayesian computations}
\usage{
credint(fit, level = 0.9)

bayesian_scoring(ni, si, fit)

bayesian_prevalence_estimate(fit)
}
\arguments{
\item{fit}{The \code{stanfit} object returned by \link{BayesianFit}}

\item{level}{Posterior probability of the credible intervals}

\item{ni}{Numeric vector of \eqn{n_i}'s, the total numbers of replicates for each individual}

\item{si}{Numeric vector of \eqn{s_i}'s, the numbers of replicates equal to 1 for each individual}
}
\value{
The \code{credint} function returns the credible interval bounds for the fixed
parameters of the Bayesian model. The default posterior probability is 90\%.

The \code{bayesian_scoring} function returns the Bayesian scores.
These scores are the posterior probabilities
that the true latent \eqn{T_i}'s are equal to 1.

The \code{bayesian_prevalence_estimate} function returns the posterior mean of the
posterior distribution on the prevalence of \eqn{T_i = 1}.
}
\description{
Get credible intervals, Bayesian scores, and prevalence estimate
from the \code{stanfit} object returned by \link{BayesianFit}.
}
\details{
See \link{BayesianFit} for details on the Bayesian model.
}
\examples{
data("periodontal")
theta <- mean(periodontal$ti)
fit <- BayesianFit(periodontal$ni, periodontal$si, chains = 2, iter = 5000)
credint(fit)
Y_B <- bayesian_scoring(periodontal$ni, periodontal$si, fit)
T_B <- classify_with_scores(Y_B, .4, .6)
theta_B <- bayesian_prevalence_estimate(fit)
cat("The Bayesian prevalence estimate is ", theta_B, "\n")
cat("The prevalence in the data is ", theta, "\n")

}
\seealso{
\code{\link{classify_with_scores}}, \code{\link{BayesianFit}}
}
