% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapTaxaObs.R
\name{MapTaxaObs}
\alias{MapTaxaObs}
\title{Taxa Observation Maps}
\usage{
MapTaxaObs(
  df_obs,
  SampID,
  TaxaID,
  TaxaCount,
  Lat,
  Long,
  output_dir = NULL,
  output_prefix = "maps.taxa",
  output_type = "pdf",
  database,
  regions,
  map_grp = NULL,
  leg_loc = "right",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{df_obs}{Observation data frame}

\item{SampID}{df_obs column name, Unique Sample identifier}

\item{TaxaID}{df_obs column name, Unique Taxa identifier}

\item{TaxaCount}{df_obs column name, Number of individuals for TaxonID and
SampID}

\item{Lat}{df_obs column name, Latitude}

\item{Long}{df_obs column name, Longitude}

\item{output_dir}{Directory to save output.  Default is working directory.}

\item{output_prefix}{Prefix to TaxaID for each file.  Default = "map.taxa."}

\item{output_type}{File format for output; jpg or pdf.}

\item{database}{maps::map function database; world, usa, state, county}

\item{regions}{maps::map function regions.  Names pertinent to map_db.}

\item{map_grp}{Map grouping variable from df_obs.  Will generate legend and
color code the points on the map.  Default = NULL}

\item{leg_loc}{Legend location text.  Default = "right"
Other values may not work properly.}

\item{verbose}{Boolean value for if status messages are output to the console.
Default = FALSE}

\item{...}{Optional arguments to be passed to methods.}
}
\value{
Taxa maps to user defined directory as jpg or pdf.
}
\description{
Map taxonomic observations from a data frame.  Input a dataframe with SampID,
TaxaID, TaxaCount, Latitude, and Longitude. Other arguments are format (jpg
vs. pdf), file name prefix, and output directory. Files are saved with the
prefix "map.taxa." by default.
}
\details{
The user will pass arguments for maps::map function that is used for the map.
For example, 'database' and 'regions'.  Without these arguments no map will
be created.

The map will have all points and colored points for each taxon.
In addition the map will include the number of samples by taxon.

The example data is fish but can be used for benthic macroinvertebrates as
well.

If use grouping variable colors are from grDevices::rainbow()

Jpg file names replace all non-alphanumeric characters with "_".

The R package maps is required for this function.
}
\examples{
df_obs     <- data_Taxa_MA
SampID     <- "estuary"
TaxaID     <- "TaxaName"
TaxaCount  <- "Count"
Lat        <- "Latitude"
Long       <- "Longitude"
output_dir <- tempdir()
output_prefix <- "maps.taxa."
output_type   <- "pdf"

myDB     <- "state"
myRegion <- "massachusetts"
myXlim   <- c(-(73+(30/60)), -(69+(56/60)))
myYlim   <- c((41+(14/60)),(42+(53/60)))

# Run function with extra arguments for map
MapTaxaObs(df_obs[1:500, ],
           SampID,
           TaxaID,
           TaxaCount,
           Lat,
           Long,
           output_dir,
           output_prefix,
           output_type,
           database = "state",
           regions = "massachusetts",
           map_grp = "estuary",
           leg_loc = "bottomleft",
           xlim = myXlim,
           ylim = myYlim,
           verbose = FALSE)
}
