% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-confint.R
\docType{methods}
\name{S4BuyseTest-confint}
\alias{S4BuyseTest-confint}
\alias{confint,S4BuyseTest-method}
\title{Extract Confidence Interval from GPC}
\usage{
\S4method{confint}{S4BuyseTest}(
  object,
  endpoint = NULL,
  statistic = NULL,
  strata = FALSE,
  cumulative = TRUE,
  null = NULL,
  conf.level = NULL,
  alternative = NULL,
  method.ci.resampling = NULL,
  order.Hprojection = NULL,
  transformation = NULL,
  cluster = NULL,
  sep = "."
)
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{S4BuyseTest}}, i.e., output of \code{\link{BuyseTest}}}

\item{endpoint}{[character] for which endpoint(s) the confidence intervals should be output?
If \code{NULL} returns the confidence intervals for all endpoints.}

\item{statistic}{[character] the statistic summarizing the pairwise comparison: \code{"netBenefit"}, \code{"winRatio"}, \code{"favorable"}, \code{"unfavorable"}.
See the documentation of the \code{coef} method for further details.
Default value read from \code{BuyseTest.options()}.}

\item{strata}{[character] the strata relative to which the statistic should be output.
Can also be \code{"global"} or \code{FALSE} to output the statistic pooled over all strata,
or \code{TRUE} to output each strata-specific statistic.}

\item{cumulative}{[logical] should the summary statistic be cumulated over endpoints?
Otherwise display the contribution of each endpoint.}

\item{null}{[numeric] right hand side of the null hypothesis (used for the computation of the p-value).}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{alternative}{[character] the type of alternative hypothesis: \code{"two.sided"}, \code{"greater"}, or \code{"less"}.
Default value read from \code{BuyseTest.options()}.}

\item{method.ci.resampling}{[character] the method used to compute the confidence intervals and p-values when using bootstrap or permutation (\code{"percentile"}, \code{"gaussian"}, \code{"student"}).
See the details section.}

\item{order.Hprojection}{[integer, 1-2] order of the H-decomposition used to compute the variance.}

\item{transformation}{[logical]  should the CI be computed on the inverse hyperbolic tangent scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.
Default value read from \code{BuyseTest.options()}. Not relevant when using permutations or percentile bootstrap.}

\item{cluster}{[numeric vector] Group of observations for which the iid assumption holds .}

\item{sep}{[character] character string used to separate the endpoint and the strata when naming the statistics.}
}
\value{
A matrix containing a column for the estimated statistic (over all strata),
the lower bound and upper bound of the confidence intervals, and the associated p-values.
When using resampling methods:
\itemize{
\item an attribute \code{n.resampling} specified how many samples have been used to compute the confidence intervals and the p-values.
\item an attribute \code{method.ci.resampling} method used to compute the confidence intervals and p-values. 
}
}
\description{
Extract confidence intervals for summary statistics (net benefit, win ratio, ...) estimated by GPC.
}
\details{
\bold{method.ci.resampling}: when using bootstrap/permutation, p-values and confidence intervals are computing as follow: \itemize{
\item \code{percentile} (bootstrap): compute the confidence interval using the quantiles of the bootstrap estimates.
Compute the p-value by finding the confidence level at which a bound of the confidence interval equals the null hypothesis.

\item \code{percentile} (permutation): apply the selected transformation to the estimate and permutation estimates.
Compute the confidence interval by (i) shfiting the estimate by the quantiles of the centered permutation estimates and (ii) back-transforming .
Compute the p-value as the relative frequency at which the estimate are less extreme than the permutation estimates.

\item \code{gaussian} (bootstrap and permutation): apply the selected transformation to the estimate and bootstrap/permutation estimates.
Estimate the variance of the estimator using the empirical variance of the transformed boostrap/permutation estimates.
Compute confidence intervals and p-values under the normality assumption and back-transform the confidence intervals.

\item \code{student} (bootstrap): apply the selected transformation to the estimate, its standard error, the bootstrap estimates, and their standard error.
Compute the studentized bootstrap estimates by dividing the centered bootstrap estimates by their standard error. 
Compute the confidence interval based on the standard error of the estimate and the quantiles of the studentized bootstrap estimates, and back-transform.
Compute the p-value by finding the confidence level at which a bound of the confidence interval equals the null hypothesis.

\item \code{student} (permutation): apply the selected transformation to the estimate, its standard error, the permutation estimates, and their standard error.
Compute the studentized permutation estimates by dividing the centered permutation estimates by their standard error.
Compute the confidence interval based on the standard error of the estimate and the quantiles of the studentized permutation estimates, and back-transform.
Compute the p-value as the relative frequency at which the studentized estimate are less extreme than the permutation studentized estimates.

}

\bold{WARNING}: when using a permutation test, the uncertainty associated with the estimator is computed under the null hypothesis.
Thus the confidence interval may not be valid if the null hypothesis is false. \cr
}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
\code{\link{S4BuyseTest-summary}} for a more detailed presentation of the \code{S4BuyseTest} object.
}
\author{
Brice Ozenne
}
\keyword{method}
