% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_annotation.R
\name{CAESAR.annotation}
\alias{CAESAR.annotation}
\title{Perform Cell Annotation Using CAESAR with Confidence and Proportion Calculation}
\usage{
CAESAR.annotation(
  seu,
  marker.freq,
  reduction.name = "caesar",
  assay.dist = "distce",
  gene.use = NULL,
  cal.confidence = TRUE,
  cal.proportions = TRUE,
  parallel = TRUE,
  ncores = 10,
  n_fake = 1001,
  seed = 1,
  threshold = 0.95,
  unassign = "unassigned",
  add.to.meta = FALSE
)
}
\arguments{
\item{seu}{A Seurat object containing cell expression data.}

\item{marker.freq}{A matrix where rows represent cell types and columns represent marker genes. The values in the matrix represent the frequency or weight of each marker gene for each cell type. Generally, it is a list of the output of function \code{markerList2mat}.}

\item{reduction.name}{A character string specifying the name of the dimensional reduction to use for constructing the distance matrix when needed. Default is "caesar".}

\item{assay.dist}{A character string specifying the assay that stores the precomputed distance matrix. If the specified assay does not exist, a distance matrix will be constructed from the reduction specified by `reduction.name`. By default, the assay corresponding to `assay.dist` is assumed to have been generated from the data in `reduction.name`. To force reconstruction of the distance matrix, set `assay.dist` to a name that does not currently exist. Default is "distce".}

\item{gene.use}{A character vector specifying which genes to use for the annotation. If \code{NULL}, all genes in the distance matrix will be used. Default is \code{NULL}.}

\item{cal.confidence}{Logical, indicating whether to calculate the confidence of the predictions. Default is \code{TRUE}.}

\item{cal.proportions}{Logical, indicating whether to calculate the mixing proportions of cell types for each cell. Default is \code{TRUE}.}

\item{parallel}{Logical, indicating whether to run the confidence calculation in parallel. Default is \code{TRUE}.}

\item{ncores}{The number of cores to use for parallel computation. Default is 10.}

\item{n_fake}{The number of fake (randomized) distance matrices to simulate for confidence calculation. Default is 1001.}

\item{seed}{The random seed for reproducibility. Default is 1.}

\item{threshold}{A numeric value specifying the confidence threshold below which a cell is labeled as \code{unassigned}. Default is 0.95.}

\item{unassign}{A character string representing the label to assign to cells below the confidence threshold. Default is "unassigned".}

\item{add.to.meta}{Logical, indicating whether to return the annotation results directly or add them to the Seurat object metadata. If \code{TRUE}, the function will return the results directly. Default is \code{FALSE}.}
}
\value{
If \code{add.to.meta = FALSE}, the Seurat object with the added metadata for predicted cell types (\code{CAESAR}), predictions with unassigned (\code{CAESARunasg}), confidence scores (\code{CAESARconf}), average distances, and mixing proportions. If \code{add.to.meta = TRUE}, a list containing the above annotation results is returned.
}
\description{
This function annotates cells in a Seurat object using marker gene frequencies and a distance matrix. It calculates average distances between cells and cell types, confidence scores, and mixing proportions. Optionally, it can add the annotations and related metrics to the Seurat object metadata.
}
\examples{
data(toydata)

seu <- toydata$seu
markers <- toydata$markers

marker.freq <- markerList2mat(list(markers))
anno_res <- CAESAR.annotation(seu, marker.freq, cal.confidence = FALSE, cal.proportions = FALSE)
str(anno_res)

}
\seealso{
\code{\link{marker.select}} for select markers.
\code{\link{find.sig.genes}} for signature gene list.
\code{\link{markerList2mat}} for marker frequency matrix.
\code{\link[ProFAST]{pdistance}} for obtain cell-gene distance matrix using co-embedding.
\code{\link{annotation_mat}} for annotation procedure.
}
