% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{chinese_cities_tbl_df}
\alias{chinese_cities_tbl_df}
\title{List of Prominent Chinese Cities}
\format{
A tibble with 367 observations and 9 variables:
\describe{
\item{city}{City name in English (character)}
\item{lat}{Latitude coordinate (numeric)}
\item{lng}{Longitude coordinate (numeric)}
\item{country}{Country name (always "China" in this dataset) (character)}
\item{iso2}{2-letter country code (always "CN" in this dataset) (character)}
\item{admin_name}{Administrative division name (province or equivalent) (character)}
\item{capital}{Administrative capital status (character)}
\item{population}{City population estimate (numeric)}
\item{population_proper}{City proper population estimate (numeric)}
}
}
\source{
Data obtained from simplemaps: \url{https://simplemaps.com/data/cn-cities}
}
\usage{
data(chinese_cities_tbl_df)
}
\description{
This dataset, chinese_cities_tbl_df, is a tibble that contains information about 367 prominent cities in China.
Each row represents a city and includes geographic coordinates (latitude and longitude), administrative information,
and population data. The dataset is a tibble (special type of data frame) that preserves the original structure
from its source simplemaps.
}
\details{
The dataset name has been kept as 'chinese_cities_tbl_df' to maintain consistency with the naming conventions
in the ChinAPIs package. The suffix 'tbl_df' indicates that this is a tibble data frame. The original content
has not been modified in any way.
}
