% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableRouteCategories.R
\name{availableRouteCategories}
\alias{availableRouteCategories}
\title{Get available drug routes}
\usage{
availableRouteCategories(cdm)
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}
}
\value{
A character vector with all available routes.
}
\description{
Get the dose form categories available in the database (see
https://doi.org/10.1002/pds.5809) for more details on how routes
were classified).
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all domains available in the CDM
availableRouteCategories(cdm = cdm)
}
}
